% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiStart.r
\name{multiStart}
\alias{multiStart}
\title{Runs SGM algorithm starting with rsp (rand start point)
\code{R} times and generates an average probability matrix over the \code{R}
restarts}
\usage{
multiStart(A, B, R, s, g, pad = 0, iter = 20)
}
\arguments{
\item{A}{adjacency matrix for \eqn{G_1}}

\item{B}{adjacency for correlated matrix \eqn{G_2}}

\item{R}{number of restarts}

\item{s}{number of seeds}

\item{g}{gamma (upper bound on alpha) should be in (0,1), max tolerance for alpha, how far away from the barycenter user is willing to go for
the initialization of \code{sgm} on any given iteration}

\item{pad}{a scalar value for padding for sgm}

\item{iter}{number of iterations allowed to be used in sgm step}
}
\value{
\eqn{n \times n} average probability matrix over all restarts.
}
\description{
Runs SGM algorithm starting with rsp (rand start point)
\code{R} times and generates an average probability matrix over the \code{R}
restarts
}
\author{
Heather Gaddy Patsolic <hgaddy1@jhu.edu>
}

