% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adjcorrH.r
\name{adjcorrH}
\alias{adjcorrH}
\title{Generates a matrix \eqn{B} which has correlation \eqn{rho}
         with the input matrix}
\usage{
adjcorrH(A, P, corr)
}
\arguments{
\item{A}{adjacency matrix of the original graph \eqn{G}}

\item{P}{matrix of probabilities, same size as A}

\item{corr}{correlation of edge in B v. A (should be positive)}
}
\value{
a graph of the same size as \code{A} such that the correlation coefficient between the entries of the two adjacency matrices is \code{corr}.
}
\description{
Generates a matrix \eqn{B} which has correlation \eqn{rho}
         with the input matrix
}
\author{
Heather Gaddy Patsolic <hgaddy1@jhu.edu>
}

