% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/localnbd-old.r, R/localnbd.r
\name{localnbd}
\alias{localnbd}
\title{Finds \eqn{h}-hop induced nbd for \eqn{G_1} and \eqn{G_2};
                     that is, finds induced subgraph generated by
                     vertices that are within a path of length \eqn{h}
                     to seed vertices.}
\usage{
localnbd(x, S, g1, g2, h, ell, R, g, pad = 0, sim = TRUE, verb = FALSE,
  plotF = FALSE)

localnbd(x, S, g1, g2, h, ell, R, g, pad = 0, sim = TRUE, verb = FALSE,
  plotF = FALSE)
}
\arguments{
\item{x}{vector of indices for vertices of interest (voi) in \eqn{G_1}}

\item{S}{vector of a set of seeds}

\item{g1}{\eqn{G_1} in \code{igraph} object where voi is known}

\item{g2}{\eqn{G_2} in \code{igraph}}

\item{h}{\eqn{h}-hop for distance from voi to other vertices
to create \eqn{h}-hop induced subgraph of \eqn{G_1}}

\item{ell}{\eqn{ell}-hop for distance from seeds to other vertices
to create \eqn{ell}-hop induced subgraph of \eqn{G_1}}

\item{R}{number of restarts for \code{multiStart}}

\item{g}{gamma to be used with \code{multiStart}, max tolerance for alpha, how far away from the barycenter user is willing to go for
the initialization of \code{sgm} on any given iteration}

\item{pad}{a scalar value for padding for sgm}

\item{sim}{boolean: default TRUE (yes, this is a simulation) --
assumes x = x' (i.e. indices for VOI in \eqn{G_1} are the same as
the indices for the corresponding matches in \eqn{G_2})}

\item{verb}{verbose outputs}

\item{plotF}{boolean to plot the probability matrix}

\item{x}{vector of indices for vertices of interest (voi) in \eqn{G_1}}

\item{S}{vector of a set of seeds}

\item{g1}{\eqn{G_1} in \code{igraph} object where voi is known}

\item{g2}{\eqn{G_2} in \code{igraph}}

\item{h}{\eqn{h}-hop for distance from voi to other vertices
to create \eqn{h}-hop induced subgraph of \eqn{G_1}}

\item{ell}{\eqn{ell}-hop for distance from seeds to other vertices
to create \eqn{ell}-hop induced subgraph of \eqn{G_1}}

\item{R}{number of restarts for \code{multiStart}}

\item{g}{gamma to be used with \code{multiStart}, max tolerance for alpha, how far away from the barycenter user is willing to go for
the initialization of \code{sgm} on any given iteration}

\item{verb}{verbose outputs}

\item{plotF}{boolean to plot the probability matrix}
}
\value{
\code{seed} \code{s} seeds

\code{cand} labels for the candidates in \eqn{G_2}

\code{ind1} labels for the vertices in \eqn{G_1}

\code{ind2} labels for the vertices in \eqn{G_2}

\code{P} matrix \eqn{P(i,j)} is the proportion of times that vertex \eqn{j} in
the induced subgraph of \eqn{G_2} was mapped to vertex \eqn{i} in the induced subgraph of \eqn{G_1}.
Then the \eqn{i-th} and \eqn{j-th} elements of the labels vector tells you which vertices these actually were
in \eqn{G_1} and \eqn{G_2}, respectively.

\code{seed} \code{s} seeds

\code{cand} labels for the candidates in \eqn{G_2}

\code{ind1} labels for the vertices in \eqn{G_1}

\code{ind2} labels for the vertices in \eqn{G_2}

\code{P} matrix \eqn{P(i,j)} is the proportion of times that vertex \eqn{j} in
the induced subgraph of \eqn{G_2} was mapped to vertex \eqn{i} in the induced subgraph of \eqn{G_1}.
Then the \eqn{i-th} and \eqn{j-th} elements of the labels vector tells you which vertices these actually were
in \eqn{G_1} and \eqn{G_2}, respectively.
}
\description{
Finds \eqn{h}-hop induced nbd for \eqn{G_1} and \eqn{G_2};
                     that is, finds induced subgraph generated by
                     vertices that are within a path of length \eqn{h}
                     to seed vertices.

Finds the seeds in an \eqn{h}-hop induced nbd of \eqn{G_1} around the
VOI, x,
                     that is, finds induced subgraph generated by
                     vertices that are within a path of length \eqn{h}
                     the VOI,
and then finds an \eqn{ell}-hop induced nbd of \eqn{G_1} around the
seeds within the \eqn{h}-hop nbd of x, and an \eqn{ell}-hop induced
nbd of \eqn{G_2} around the corresponding seeds.
Then, matches these induced subgraphs via \code{multiStart}.
}
\author{
Youngser Park <youngser@jhu.edu>

Youngser Park <youngser@jhu.edu>
}

