% make integrated response plot
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%   Thermodynamically Consistent Model Calibration   %%%%%%%%%%%%
%%%%%%%%%%%              in Chemical Kinetics                  %%%%%%%%%%%%
%%%%%%%%%%%                MAKE FINAL PLOTS                    %%%%%%%%%%%%
%%%%%%%%%%%            Authors: Jenkinson/Goutsias             %%%%%%%%%%%%
%%%%%%%%%%%             Last Modified: 12/02/2010              %%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%

Av = 6.0221415e+23;   % Avogadro number (1/mol)
V  = 1e-15;           % system volume (m^3)

%
% load results
%

load ../estimation/results/workspaces/tcmc/tcmc.mat

%
% initialize
%

time        = 0:.1:800;
numPlotSamp = 500;

minEGFconc = 0.001;
maxEGFconc = 100;
convfac    = 602214/6045;

EGFconc = logspace(log10(minEGFconc),log10(maxEGFconc),numPlotSamp);
EGF     = logspace(log10(convfac*minEGFconc),log10(convfac*maxEGFconc),numPlotSamp);

integrPub = zeros(numPlotSamp,1);
integrEst = zeros(numPlotSamp,1);

%
% Calculate Published response to EGF stimulus
%

for index = 1:numPlotSamp
    schoeberl(1)     = EGF(index);
    output1          = Schoeberl2002_EGF_MAPK(time,x0,schoeberl);
    integrPub(index) = trapz(output1.time,output1.variablevalues(:,3));
end

%
% Calculate Estimated response to EGF stimulus
%

kappaEst = schoeberl;
params   = reactToParamMat*exp(logKappaFinal);

for index = 1:dim
    if params(index)>0
        kappaEst(index) = params(index);
    end
end

for index = 1:numPlotSamp
    kappaEst(1)      = EGF(index);
    output2          = Schoeberl2002_EGF_MAPK(time,x0,kappaEst);
    integrEst(index) = trapz(output2.time,output2.variablevalues(:,3));
end

%
% Plot Results
%

lnw = 2;
set(0,'DefaultAxesLineWidth',2,'DefaultAxesFontSize',14,...
      'DefaultAxesFontWeight','normal');

figure;  
loglog(EGFconc,integrEst./(Av*V),'k','LineWidth',lnw)
hold on;
loglog(EGFconc,integrPub./(Av*V),'k:','LineWidth',lnw)
xlabel('EGF stimulus (ng/mL)')
ylabel('Integrated Response')
legend('tcmc','published')
set(gca,'XDir','reverse')
saveas(gcf,'figures/intresp.fig')