% make final plots
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%   Thermodynamically Consistent Model Calibration   %%%%%%%%%%%%
%%%%%%%%%%%              in Chemical Kinetics                  %%%%%%%%%%%%
%%%%%%%%%%%                MAKE FINAL PLOTS                    %%%%%%%%%%%%
%%%%%%%%%%%            Authors: Jenkinson/Goutsias             %%%%%%%%%%%%
%%%%%%%%%%%             Last Modified: 12/02/2010              %%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%

loadModel;

%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Make long-term dynamic plots
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% 

load ../estimation/results/workspaces/estimated/estimated.mat

EGF0 = [4962;496.2;49.6;12.4;6.2];
time = 0:.1:240;

%      
% set parameters
%

params = reactToParamMat*exp(logKappaFinal);

for index = 1:dim
    if params(index) > 0
        schoeberl(index) = params(index);
    end
end

%
% set initial EGF concentrations and compute dynamics
%

schoeberl(1) = EGF0(4);
output4e     = Schoeberl2002_EGF_MAPK(time,x0,schoeberl);

schoeberl(1) = EGF0(5);
output5e     = Schoeberl2002_EGF_MAPK(time,x0,schoeberl);

load ../estimation/results/workspaces/tcmc/tcmc.mat

EGF0 = [4962;496.2;49.6;12.4;6.2];
time = 0:.1:240;

%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Compute dynamics for estimated parameters
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%      
% set parameters
%

params = reactToParamMat*exp(logKappaFinal);

for index = 1:dim
    if params(index) > 0
        schoeberl(index) = params(index);
    end
end

%
% set initial EGF concentrations and compute dynamics
%

schoeberl(1) = EGF0(4);
output4t     = Schoeberl2002_EGF_MAPK(time,x0,schoeberl);

schoeberl(1) = EGF0(5);
output5t     = Schoeberl2002_EGF_MAPK(time,x0,schoeberl);

t{1}=[0;1;3;5;10;30;60];
ERK{1}=[%50 ng/mL
        330000
        748000
        9570000
        11000000
        10010000
        6490000
        2420000];

t{2}=[0;1;3;5;10;30;60];	
ERK{2}=[%5ng/mL	
        649000
        957000
        6875000
        9713000
        11000000
        7645000
        2640000];
		
t{3}=[0;1;3;5;10;30;60];    
ERK{3}=[%0.5ng/mL			
        418000
        429000
        495000
        5940000
        11000000
        5896000
        2981000];
		
t{4}=[0;3;5;10;15;20;30;60];		
ERK{4}=[%0.125ng/mL	
        286000
        616000
        2046000
        5676000
        7315000
        4070000
        2970000
        1947000];

t{5}=[0;3;5;10;15;20;30;60];
ERK{5}=[%0.0625ng/mL
        11000
        33000
        1628000
        3883000
        6677000
        1716000
        1562000
        143000];
    
A  = 6.0221415e+23;   % Avogadro number (1/mol)
V  = 1e-15;           % system volume (m^3)    

lnw = 2;
set(0,'DefaultAxesLineWidth',2,'DefaultAxesFontSize',14,...
      'DefaultAxesFontWeight','normal');

figure;
hold on;
plot(output4e.time,output4e.variablevalues(:,3)/(A*V),'b--','Linewidth',lnw);
hold on;
plot(output4t.time,output4t.variablevalues(:,3)/(A*V),'b','Linewidth',lnw);
hold on;
plot(output5e.time,output5e.variablevalues(:,3)/(A*V),'r--','Linewidth',lnw);
hold on
plot(output5t.time,output5t.variablevalues(:,3)/(A*V),'r','Linewidth',lnw);
xlabel('time (min)');
ylabel('ERK-PP (mol/m^{3})');
axis tight

axes('position',[.4 .4 .5 .5])
hold on;
plot(output4e.time(1:601),output4e.variablevalues(1:601,3)/(A*V),'b--','Linewidth',lnw);
hold on;
plot(output4t.time(1:601),output4t.variablevalues(1:601,3)/(A*V),'b','Linewidth',lnw);
hold on;
plot(output5e.time(1:601),output5e.variablevalues(1:601,3)/(A*V),'r--','Linewidth',lnw);
hold on;
plot(output5t.time(1:601),output5t.variablevalues(1:601,3)/(A*V),'r','Linewidth',lnw);
hold on;
plot(t{4},ERK{4}/(A*V),'bo','Linewidth',3*lnw);
plot(t{5},ERK{5}/(A*V),'ro','Linewidth',3*lnw);
xlabel('time (min)');
axis tight
saveas(gcf,'figures/longTerm.fig');

%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Compute published and estimated portion of plots
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% 

clear all; 

load ../estimation/results/workspaces/estimated/estimated.mat

EGF0 = [4962;496.2;49.6;12.4;6.2];

%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Compute dynamics for published parameters
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% 

schoeberl(1) = EGF0(1);
output1p     = Schoeberl2002_EGF_MAPK(time,x0,schoeberl);

schoeberl(1) = EGF0(2);
output2p     = Schoeberl2002_EGF_MAPK(time,x0,schoeberl);

schoeberl(1) = EGF0(3);
output3p     = Schoeberl2002_EGF_MAPK(time,x0,schoeberl);

schoeberl(1) = EGF0(4);
output4p     = Schoeberl2002_EGF_MAPK(time,x0,schoeberl);

schoeberl(1) = EGF0(5);
output5p     = Schoeberl2002_EGF_MAPK(time,x0,schoeberl);

%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Compute dynamics for estimated parameters
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%      
% set parameters
%

params = reactToParamMat*exp(logKappaFinal);

for index = 1:dim
    if params(index) > 0
        schoeberl(index) = params(index);
    end
end

%
% set initial EGF concentrations and compute dynamics
%

schoeberl(1) = EGF0(1);
output1e     = Schoeberl2002_EGF_MAPK(time,x0,schoeberl);

schoeberl(1) = EGF0(2);
output2e     = Schoeberl2002_EGF_MAPK(time,x0,schoeberl);

schoeberl(1) = EGF0(3);
output3e     = Schoeberl2002_EGF_MAPK(time,x0,schoeberl);

schoeberl(1) = EGF0(4);
output4e     = Schoeberl2002_EGF_MAPK(time,x0,schoeberl);

schoeberl(1) = EGF0(5);
output5e     = Schoeberl2002_EGF_MAPK(time,x0,schoeberl);

%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Compute TCMC portion of plots
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% 

load ../estimation/results/workspaces/tcmc/tcmc.mat

EGF0 = [4962;496.2;49.6;12.4;6.2];

t{1}=[0;1;3;5;10;30;60];
ERK{1}=[%50 ng/mL
        330000
        748000
        9570000
        11000000
        10010000
        6490000
        2420000];

t{2}=[0;1;3;5;10;30;60];	
ERK{2}=[%5ng/mL	
        649000
        957000
        6875000
        9713000
        11000000
        7645000
        2640000];
		
t{3}=[0;1;3;5;10;30;60];    
ERK{3}=[%0.5ng/mL			
        418000
        429000
        495000
        5940000
        11000000
        5896000
        2981000];
		
t{4}=[0;3;5;10;15;20;30;60];		
ERK{4}=[%0.125ng/mL	
        286000
        616000
        2046000
        5676000
        7315000
        4070000
        2970000
        1947000];

t{5}=[0;3;5;10;15;20;30;60];
ERK{5}=[%0.0625ng/mL
        11000
        33000
        1628000
        3883000
        6677000
        1716000
        1562000
        143000];

%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Compute dynamics for estimated parameters
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%      
% set parameters
%

params = reactToParamMat*exp(logKappaFinal);

for index = 1:dim
    if params(index) > 0
        schoeberl(index) = params(index);
    end
end

%
% set initial EGF concentrations and compute dynamics
%

schoeberl(1) = EGF0(1);
output1t     = Schoeberl2002_EGF_MAPK(time,x0,schoeberl);

schoeberl(1) = EGF0(2);
output2t     = Schoeberl2002_EGF_MAPK(time,x0,schoeberl);

schoeberl(1) = EGF0(3);
output3t     = Schoeberl2002_EGF_MAPK(time,x0,schoeberl);

schoeberl(1) = EGF0(4);
output4t     = Schoeberl2002_EGF_MAPK(time,x0,schoeberl);

schoeberl(1) = EGF0(5);
output5t     = Schoeberl2002_EGF_MAPK(time,x0,schoeberl);

%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Plot results for published and estimated parameters
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%  

A  = 6.0221415e+23;   % Avogadro number (1/mol)
V  = 1e-15;           % system volume (m^3)  

lnw = 2;
set(0,'DefaultAxesLineWidth',2,'DefaultAxesFontSize',14,...
      'DefaultAxesFontWeight','normal');

figure;
plot(output1p.time,output1p.variablevalues(:,3)/(A*V),'k:','Linewidth',lnw);
hold on;
plot(output1e.time,output1e.variablevalues(:,3)/(A*V),'k--','Linewidth',lnw);
hold on;
plot(output1t.time,output1t.variablevalues(:,3)/(A*V),'k','Linewidth',lnw);
hold on;
legend('published','estimated','tcmc');
plot(t{1},ERK{1}/(A*V),'ro','Linewidth',3*lnw);
hold on;
xlabel('time (min)');
ylabel('ERK-PP (mol/m^{3})');
title('50 ng/mL EGF')
saveas(gcf,'figures/50EGF.fig');

figure;
plot(output2p.time,output2p.variablevalues(:,3)/(A*V),'k:','Linewidth',lnw);
hold on;
plot(output2e.time,output2e.variablevalues(:,3)/(A*V),'k--','Linewidth',lnw);
hold on;
plot(output2t.time,output2t.variablevalues(:,3)/(A*V),'k','Linewidth',lnw);
hold on;
legend('published','estimated','tcmc');
plot(t{2},ERK{2}/(A*V),'ro','Linewidth',3*lnw);
hold on;
xlabel('time (min)');
ylabel('ERK-PP (mol/m^{3})');
title('5 ng/mL EGF')
saveas(gcf,'figures/5EGF.fig');

figure;
plot(output3p.time,output3p.variablevalues(:,3)/(A*V),'k:','Linewidth',lnw);
hold on;
plot(output3e.time,output3e.variablevalues(:,3)/(A*V),'k--','Linewidth',lnw);
hold on;
plot(output3t.time,output3t.variablevalues(:,3)/(A*V),'k','Linewidth',lnw);
hold on;
legend('published','estimated','tcmc');
plot(t{3},ERK{3}/(A*V),'ro','Linewidth',3*lnw);
hold on;
xlabel('time (min)');
ylabel('ERK-PP (mol/m^{3})');
title('0.5 ng/mL EGF')
saveas(gcf,'figures/05EGF.fig');

figure;
plot(output4p.time,output4p.variablevalues(:,3)/(A*V),'k:','Linewidth',lnw);
hold on;
plot(output4e.time,output4e.variablevalues(:,3)/(A*V),'k--','Linewidth',lnw);
hold on;
plot(output4t.time,output4t.variablevalues(:,3)/(A*V),'k','Linewidth',lnw);
hold on;
legend('published','estimated','tcmc');
plot(t{4},ERK{4}/(A*V),'ro','Linewidth',3*lnw);
hold on;
xlabel('time (min)');
ylabel('ERK-PP (mol/m^{3})');
title('0.125 ng/mL EGF')
saveas(gcf,'figures/0125EGF.fig');

figure;
plot(output5p.time,output5p.variablevalues(:,3)/(A*V),'k:','Linewidth',lnw);
hold on;
plot(output5e.time,output5e.variablevalues(:,3)/(A*V),'k--','Linewidth',lnw);
hold on;
plot(output5t.time,output5t.variablevalues(:,3)/(A*V),'k','Linewidth',lnw);
hold on;
legend('published','estimated','tcmc');
plot(t{5},ERK{5}/(A*V),'ro','Linewidth',3*lnw);
hold on;
xlabel('time (min)');
ylabel('ERK-PP (mol/m^{3})');
title('0.0625 ng/mL EGF')
saveas(gcf,'figures/00625EGF.fig');

%
% Make the integrated response plot
%

clear all;

makeIntegrPlot;

pause;

%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Final housekeeping
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%

close all;
delete('Schoeberl2002_EGF_MAPK.mexw32')