% find square error cost
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%   Thermodynamically Consistent Model Calibration   %%%%%%%%%%%%
%%%%%%%%%%%              in Chemical Kinetics                  %%%%%%%%%%%%
%%%%%%%%%%%        THERMODYNAMICALLY CONSTRAINED MODEL         %%%%%%%%%%%%
%%%%%%%%%%%                    CALIBRATION                     %%%%%%%%%%%%
%%%%%%%%%%%            Authors: Jenkinson/Goutsias             %%%%%%%%%%%%
%%%%%%%%%%%             Last Modified: 12/02/2010              %%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%

function sqrError = sqrErrCost(logKappa,schoeberl,reactToParamMat,x0,time,dim)

%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Enter experimental data
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%

EGF0 = [4962;496.2;49.6;12.4;6.2];

t{1}=[0;1;3;5;10;30;60];
ERK{1}=[%50 ng/mL
        330000
        748000
        9570000
        11000000
        10010000
        6490000
        2420000];

t{2}=[0;1;3;5;10;30;60];	
ERK{2}=[%5ng/mL	
        649000
        957000
        6875000
        9713000
        11000000
        7645000
        2640000];
		
t{3}=[0;1;3;5;10;30;60];    
ERK{3}=[%0.5ng/mL		
        418000
        429000
        495000
        5940000
        11000000
        5896000
        2981000];
		
t{4}=[0;3;5;10;15;20;30;60];		
ERK{4}=[%0.125ng/mL		
        286000
        616000
        2046000
        5676000
        7315000
        4070000
        2970000
        1947000];

t{5}=[0;3;5;10;15;20;30;60];
ERK{5}=[%0.0625ng/mL
        11000
        33000
        1628000
        3883000
        6677000
        1716000
        1562000
        143000];

%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Compute dynamics and corresponding cost
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%    
% Set parameters
%

params = reactToParamMat*exp(logKappa);

for index = 1:dim
    if params(index) > 0
        schoeberl(index) = params(index);
    end
end

sqrError = 0;
for index1 = 1:5
    % set initial EGF concentration
    schoeberl(1) = EGF0(index1);
    
    % find dynamics
    output  = Schoeberl2002_EGF_MAPK(time,x0,schoeberl);
    ERKconc = output.variablevalues(:,3);
    
    % compute error
    for index2   = 1:length(t{index1})
        distance = abs(output.time-t{index1}(index2));
        location = find(distance == min(distance),1);
        sqrError = sqrError + (ERKconc(location)-ERK{index1}(index2))^2;
    end
end