% make plots
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%   Thermodynamically Consistent Model Calibration   %%%%%%%%%%%%
%%%%%%%%%%%              in Chemical Kinetics                  %%%%%%%%%%%%
%%%%%%%%%%%        THERMODYNAMICALLY CONSTRAINED MODEL         %%%%%%%%%%%%
%%%%%%%%%%%                    CALIBRATION                     %%%%%%%%%%%%
%%%%%%%%%%%            Authors: Jenkinson/Goutsias             %%%%%%%%%%%%
%%%%%%%%%%%             Last Modified: 12/02/2010              %%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%

function makePlots(logKappaFinal,x0,time,reactToParamMat,...
                    schoeberl,ImposeThermoConst,dim)

%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Experimental Data
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%  

EGF0 = [4962;496.2;49.6;12.4;6.2];

t{1}=[0;1;3;5;10;30;60];
ERK{1}=[%50 ng/mL
        330000
        748000
        9570000
        11000000
        10010000
        6490000
        2420000];

t{2}=[0;1;3;5;10;30;60];	
ERK{2}=[%5ng/mL	
        649000
        957000
        6875000
        9713000
        11000000
        7645000
        2640000];
		
t{3}=[0;1;3;5;10;30;60];    
ERK{3}=[%0.5ng/mL			
        418000
        429000
        495000
        5940000
        11000000
        5896000
        2981000];
		
t{4}=[0;3;5;10;15;20;30;60];		
ERK{4}=[%0.125ng/mL	
        286000
        616000
        2046000
        5676000
        7315000
        4070000
        2970000
        1947000];

t{5}=[0;3;5;10;15;20;30;60];
ERK{5}=[%0.0625ng/mL
        11000
        33000
        1628000
        3883000
        6677000
        1716000
        1562000
        143000];

%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Compute dynamics for published parameters
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% 

schoeberl(1) = EGF0(1);
output1p     = Schoeberl2002_EGF_MAPK(time,x0,schoeberl);

schoeberl(1) = EGF0(2);
output2p     = Schoeberl2002_EGF_MAPK(time,x0,schoeberl);

schoeberl(1) = EGF0(3);
output3p     = Schoeberl2002_EGF_MAPK(time,x0,schoeberl);

schoeberl(1) = EGF0(4);
output4p     = Schoeberl2002_EGF_MAPK(time,x0,schoeberl);

schoeberl(1) = EGF0(5);
output5p     = Schoeberl2002_EGF_MAPK(time,x0,schoeberl);

%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Compute dynamics for estimated parameters
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%      
% set parameters
%

params = reactToParamMat*exp(logKappaFinal);

for index = 1:dim
    if params(index) > 0
        schoeberl(index) = params(index);
    end
end

%
% set initial EGF concentrations and compute dynamics
%

schoeberl(1) = EGF0(1);
output1e     = Schoeberl2002_EGF_MAPK(time,x0,schoeberl);

schoeberl(1) = EGF0(2);
output2e     = Schoeberl2002_EGF_MAPK(time,x0,schoeberl);

schoeberl(1) = EGF0(3);
output3e     = Schoeberl2002_EGF_MAPK(time,x0,schoeberl);

schoeberl(1) = EGF0(4);
output4e     = Schoeberl2002_EGF_MAPK(time,x0,schoeberl);

schoeberl(1) = EGF0(5);
output5e     = Schoeberl2002_EGF_MAPK(time,x0,schoeberl);

%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Plot results for published and estimated parameters
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%  

lnw = 2;
set(0,'DefaultAxesLineWidth',2,'DefaultAxesFontSize',14,...
      'DefaultAxesFontWeight','normal');

figure(1);
plot(output1p.time,output1p.variablevalues(:,3),'k:','Linewidth',lnw);
hold on;
plot(output1e.time,output1e.variablevalues(:,3),'k','Linewidth',lnw);
hold on;
legend('published','estimated');
plot(t{1},ERK{1},'ro','Linewidth',3*lnw);
hold on;
xlabel('time (min)');ylabel('ERK-PP (# of molecules)');title('50 ng/mL EGF')

if ImposeThermoConst
    saveas(gcf,'results/figures/tcmc/50EGF.fig');
else
    saveas(gcf,'results/figures/estimated/50EGF.fig');
end

figure(2);
plot(output2p.time,output2p.variablevalues(:,3),'k:','Linewidth',lnw);
hold on;
plot(output2e.time,output2e.variablevalues(:,3),'k','Linewidth',lnw);
hold on;
legend('published','estimated');
plot(t{2},ERK{2},'ro','Linewidth',3*lnw);
hold on;
xlabel('time (min)');ylabel('ERK-PP (# of molecules)');title('5 ng/mL EGF')

if ImposeThermoConst
    saveas(gcf,'results/figures/tcmc/5EGF.fig');
else
    saveas(gcf,'results/figures/estimated/5EGF.fig');
end

figure(3);
plot(output3p.time,output3p.variablevalues(:,3),'k:','Linewidth',lnw);
hold on;
plot(output3e.time,output3e.variablevalues(:,3),'k','Linewidth',lnw);
hold on;
legend('published','estimated');
plot(t{3},ERK{3},'ro','Linewidth',3*lnw);
hold on;
xlabel('time (min)');ylabel('ERK-PP (# of molecules)');title('0.5 ng/mL EGF')

if ImposeThermoConst
    saveas(gcf,'results/figures/tcmc/05EGF.fig');
else
    saveas(gcf,'results/figures/estimated/05EGF.fig');
end

figure(4);
plot(output4p.time,output4p.variablevalues(:,3),'k:','Linewidth',lnw);
hold on;
plot(output4e.time,output4e.variablevalues(:,3),'k','Linewidth',lnw);
hold on;
legend('published','estimated');
plot(t{4},ERK{4},'ro','Linewidth',3*lnw);
hold on;
xlabel('time (min)');ylabel('ERK-PP (# of molecules)');title('0.125 ng/mL EGF')

if ImposeThermoConst
    saveas(gcf,'results/figures/tcmc/0125EGF.fig');
else
    saveas(gcf,'results/figures/estimated/0125EGF.fig');
end

figure(5);
plot(output5p.time,output5p.variablevalues(:,3),'k:','Linewidth',lnw);
hold on;
plot(output5e.time,output5e.variablevalues(:,3),'k','Linewidth',lnw);
hold on;
legend('published','estimated');
plot(t{5},ERK{5},'ro','Linewidth',3*lnw);
hold on;
xlabel('time (min)');ylabel('ERK-PP (# of molecules)');title('0.0625 ng/mL EGF')

if ImposeThermoConst
    saveas(gcf,'results/figures/tcmc/00625EGF.fig');
else
    saveas(gcf,'results/figures/estimated/00625EGF.fig');
end