% initialization
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%   Thermodynamically Consistent Model Calibration   %%%%%%%%%%%%
%%%%%%%%%%%              in Chemical Kinetics                  %%%%%%%%%%%%
%%%%%%%%%%%        THERMODYNAMICALLY CONSTRAINED MODEL         %%%%%%%%%%%%
%%%%%%%%%%%                    CALIBRATION                     %%%%%%%%%%%%
%%%%%%%%%%%            Authors: Jenkinson/Goutsias             %%%%%%%%%%%%
%%%%%%%%%%%             Last Modified: 12/02/2010              %%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%

%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Load model
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%

modelObj = SBmodel('BIOMD0000000019.xml'); % load SBML model from database
time     = 0:0.1:60;                       % set simulation time

SBPDmakeMEXmodel(modelObj)                 % make MEX code for rapid simulation

%
% Get stoichiometry matrix, molecular species, reactions and reversibility
%

[stoich,componentNames,reactionNames,reversible] = SBstoichiometry(modelObj);

%
% NOTE: stoich does not involve EGF, which is the only clamped species. 
%       It only involves dynamic species.
%

%
% Get published kappa values
%

[kappaNames,schoeberl] = SBparameters(modelObj);
dim = length(schoeberl); % number of parameters used in Schoeberl model

%
% Get initial molecular concentrations
%

x0 = SBinitialconditions(modelObj);   % remaining ICs

%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Set details about closed biochemical reaction system model
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%

%
% Tag reversible reactions that should not be included in closed subsystem
%

closedReaction = reversible; % only reversible reactions could be in closed subsystem

closedReaction(5)   = 0;  % non-mass action rate law used
closedReaction(19)  = 0;  % GDP turns into GTP with no phosphate source (simplified reaction mechanism)
closedReaction(21)  = 0;  % GDP turns into GTP with no phosphate source (simplified reaction mechanism)
closedReaction(27)  = 0;  % GDP turns into GTP with no phosphate source (simplified reaction mechanism)
closedReaction(31)  = 0;  % GDP turns into GTP with no phosphate source (simplified reaction mechanism)
closedReaction(43)  = 0;  % non-mass action rate law used
closedReaction(45)  = 0;  % non-mass action rate law used and phosphate left unbalanced
closedReaction(47)  = 0;  % non-mass action rate law used and phosphate left unbalanced
closedReaction(49)  = 0;  % non-mass action rate law used and phosphate left unbalanced
closedReaction(51)  = 0;  % non-mass action rate law used and phosphate left unbalanced
closedReaction(53)  = 0;  % non-mass action rate law used and phosphate left unbalanced
closedReaction(55)  = 0;  % non-mass action rate law used and phosphate left unbalanced
closedReaction(57)  = 0;  % non-mass action rate law used and phosphate left unbalanced
closedReaction(59)  = 0;  % non-mass action rate law used and phosphate left unbalanced
closedReaction(66)  = 0;  % GDP turns into GTP with no phosphate source (simplified reaction mechanism)
closedReaction(68)  = 0;  % GDP turns into GTP with no phosphate source (simplified reaction mechanism)
closedReaction(74)  = 0;  % GDP turns into GTP with no phosphate source (simplified reaction mechanism)
closedReaction(78)  = 0;  % GDP turns into GTP with no phosphate source (simplified reaction mechanism)
closedReaction(85)  = 0;  % non-mass action rate law used
closedReaction(87)  = 0;  % non-mass action rate law used and phosphate left unbalanced
closedReaction(89)  = 0;  % non-mass action rate law used and phosphate left unbalanced
closedReaction(91)  = 0;  % non-mass action rate law used and phosphate left unbalanced
closedReaction(93)  = 0;  % non-mass action rate law used and phosphate left unbalanced
closedReaction(95)  = 0;  % non-mass action rate law used and phosphate left unbalanced
closedReaction(97)  = 0;  % non-mass action rate law used and phosphate left unbalanced
closedReaction(99)  = 0;  % non-mass action rate law used and phosphate left unbalanced
closedReaction(101) = 0;  % non-mass action rate law used and phosphate left unbalanced
closedReaction(107) = 0;  % non-mass action rate law used
closedReaction(110) = 0;  % non-mass action rate law used
closedReaction(113) = 0;  % non-mass action rate law used
closedReaction(116) = 0;  % non-mass action rate law used
closedReaction(119) = 0;  % non-mass action rate law used
closedReaction(122) = 0;  % non-mass action rate law used
closedReaction(125) = 0;  % non-mass action rate law used

%
% Set system size parameters
%

Nd = size(stoich,1);
M  = size(stoich,2);
M0 = sum(closedReaction);
J  = 2*M;

%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Find mapping and inverse mapping from parameters to reactions
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%

parToReact{1}  = [];                                            % 1   x1
parToReact{2}  = [1];                                           % 2   k1   v1 forward
parToReact{3}  = [2];                                           % 3   kr1  v1 reverse
parToReact{4}  = [4,22];                                        % 4   kr2  v2 reverse,  v11 reverse
parToReact{5}  = [3,21];                                        % 5   k2   v2 forward,  v11 forward
parToReact{6}  = [5,23];                                        % 6   k3   v3 forward,  v12 forward
parToReact{7}  = [6,24];                                        % 7   kr3  v3 reverse,  v12 reverse
parToReact{8}  = [7,211,217,223,229,235,241,247];               % 8   k4   v4 forward,  v106 forward,  v109 forward,  v112 forward,  v115 forward,  v118 forward,  v121 forward,  v124 forward
parToReact{9}  = [8,212,218,224,230,236,242,248];               % 9   kr4  v4 reverse,  v106 reverse,  v109 reverse,  v112 reverse,  v115 reverse,  v118 reverse,  v121 reverse,  v124 reverse
parToReact{10} = [11,203,205,207,209,215,221,227,233,239,245];  % 10  k6   v6 forward,  v102 forward,  v103 forward,  v104 forward,  v105 forward,  v108 forward,  v111 forward,  v114 forward,  v117 forward,  v120 forward,  v123 forward
parToReact{11} = [12,204,206,208,210,216,222,228,234,240,246];  % 11  kr6  v6 reverse,  v102 reverse,  v103 reverse,  v104 reverse,  v105 reverse,  v108 reverse,  v111 reverse,  v114 reverse,  v117 reverse,  v120 reverse,  v123 reverse
parToReact{12} = [13,17];                                       % 12  k7   v7 forward,  v9 forward
parToReact{13} = [15];                                          % 13  k8   v8 forward
parToReact{14} = [16];                                          % 14  kr8  v8 reverse
parToReact{15} = [19];                                          % 15  k10  v10 forward
parToReact{16} = [20];                                          % 16  kr10 v10 reverse
parToReact{17} = [];                                            % 17  kr11
parToReact{18} = [];                                            % 18  k11
parToReact{19} = [];                                            % 19  kr12
parToReact{20} = [];                                            % 20  k12
parToReact{21} = [25];                                          % 21  k13  v13 forward
parToReact{22} = [27];                                          % 22  k14  v14 forward
parToReact{23} = [28];                                          % 23  kr14 v14 reverse 
parToReact{24} = [29];                                          % 24  k15  v15 forward
parToReact{25} = [32,126];                                      % 25  kr16 v16 reverse,  v63 reverse
parToReact{26} = [31,125];                                      % 26  k16  v16 forward,  v63 forward
parToReact{27} = [34,128];                                      % 27  kr17 v17 reverse,  v64 reverse
parToReact{28} = [33,127];                                      % 28  k17  v17 forward,  v64 forward
parToReact{29} = [36,52,130,146];                               % 29  kr18 v18 reverse,  v26 reverse,  v65 reverse,  v73 reverse
parToReact{30} = [35,51,129,145];                               % 30  k18  v18 forward,  v26 forward,  v65 forward,  v73 forward
parToReact{31} = [38,54,132,148];                               % 31  kr19 v19 reverse,  v27 reverse,  v66 reverse,  v74 reverse
parToReact{32} = [37,53,131,147];                               % 32  k19  v19 forward,  v27 forward,  v66 forward,  v74 forward
parToReact{33} = [40,60,134,154];                               % 33  kr20 v20 reverse,  v30 reverse,  v67 reverse,  v77 reverse
parToReact{34} = [39,59,133,153];                               % 34  k20  v20 forward,  v30 forward,  v67 forward,  v77 forward
parToReact{35} = [41,61,135,155];                               % 35  k21  v21 forward,  v31 forward,  v68 forward,  v78 forward
parToReact{36} = [42,62,136,156];                               % 36  kr21 v21 reverse,  v31 reverse,  v68 reverse,  v78 reverse
parToReact{37} = [43,137];                                      % 37  k22  v22 forward,  v69 forward
parToReact{38} = [44,138];                                      % 38  kr22 v22 reverse,  v69 reverse
parToReact{39} = [45,139];                                      % 39  k23  v23 forward,  v70 forward
parToReact{40} = [46,140];                                      % 40  kr23 v23 reverse,  v70 reverse
parToReact{41} = [47,75,141];                                   % 41  k24  v24 forward,  v38 forward,  v71 forward
parToReact{42} = [48,76,142];                                   % 42  kr24 v24 reverse,  v38 reverse,  v71 reverse
parToReact{43} = [50,144];                                      % 43  kr25 v25 reverse,  v72 reverse
parToReact{44} = [49,143];                                      % 44  k25  v25 forward,  v72 forward
parToReact{45} = [55,149];                                      % 45  k28  v28 forward,  v75 forward
parToReact{46} = [56,150];                                      % 46  kr28 v28 reverse,  v75 reverse
parToReact{47} = [57,151];                                      % 47  k29  v29 forward,  v76 forward
parToReact{48} = [58,152];                                      % 48  kr29 v29 reverse,  v76 reverse
parToReact{49} = [64,158];                                      % 49  kr32 v32 reverse,  v79 reverse
parToReact{50} = [63,157];                                      % 50  k32  v32 forward,  v79 forward
parToReact{51} = [65];                                          % 51  k33  v33 forward
parToReact{52} = [66];                                          % 52  kr33 v33 reverse
parToReact{53} = [67,159];                                      % 53  k34  v34 forward,  v80 forward
parToReact{54} = [68,160];                                      % 54  kr34 v34 reverse,  v80 reverse
parToReact{55} = [69];                                          % 55  k35  v35 forward
parToReact{56} = [70];                                          % 56  kr35 v35 reverse
parToReact{57} = [71];                                          % 57  Vm36 v36 forward M-M Vmax
parToReact{58} = [72];                                          % 58  Km36 v36 forward M-M constant
parToReact{59} = [73,77,161,163];                               % 59  k37  v37 forward,  v39 forward,  v81 forward,  v82 forward
parToReact{60} = [74,78,162,164];                               % 60  kr37 v37 reverse,  v39 reverse,  v81 reverse,  v82 reverse
parToReact{61} = [79];                                          % 61  k40  v40 forward
parToReact{62} = [80];                                          % 62  kr40 v40 reverse
parToReact{63} = [82,166];                                      % 63  kr41 v41 reverse,  v83 reverse
parToReact{64} = [81,165];                                      % 64  k41  v41 forward,  v83 forward
parToReact{65} = [83,167];                                      % 65  k42  v42 forward,  v84 forward
parToReact{66} = [84,168];                                      % 66  kr42 v42 reverse,  v84 reverse
parToReact{67} = [85,169];                                      % 67  k43  v43 forward,  v85 forward
parToReact{68} = [88,92,172,176];                               % 68  kr44 v44 reverse,  v46 reverse,  v86 reverse,  v88 reverse
parToReact{69} = [87,91,171,175];                               % 69  k44  v44 forward,  v46 forward,  v86 forward,  v88 forward
parToReact{70} = [89,173];                                      % 70  k45  v45 forward,  v87 forward
parToReact{71} = [93,177];                                      % 71  k47  v47 forward,  v89 forward
parToReact{72} = [96,180];                                      % 72  kr48 v48 reverse,  v90 reverse
parToReact{73} = [95,179];                                      % 73  k48  v48 forward,  v90 forward
parToReact{74} = [97,101,181,185];                              % 74  k49  v49 forward,  v51 forward,  v91 forward,  v93 forward
parToReact{75} = [100,184];                                     % 75  kr50 v50 reverse,  v92 reverse
parToReact{76} = [99,183];                                      % 76  k50  v50 forward,  v92 forward
parToReact{77} = [103,107,187,191];                             % 77  k52  v52 forward,  v54 forward,  v94 forward,  v96 forward
parToReact{78} = [104,108,188,192];                             % 78  kr52 v52 reverse,  v54 reverse,  v94 reverse,  v96 reverse
parToReact{79} = [105,189];                                     % 79  k53  v53 forward,  v95 forward
parToReact{80} = [109,193];                                     % 80  k55  v55 forward,  v97 forward
parToReact{81} = [112,196];                                     % 81  kr56 v56 reverse,  v98 reverse
parToReact{82} = [111,195];                                     % 82  k56  v56 forward,  v98 forward
parToReact{83} = [113,197];                                     % 83  k57  v57 forward,  v99 forward
parToReact{84} = [116,200];                                     % 84  kr58 v58 reverse,  v100 reverse
parToReact{85} = [115,199];                                     % 85  k58  v58 forward,  v100 forward
parToReact{86} = [117,201];                                     % 86  k59  v59 forward,  v101 forward
parToReact{87} = [119,123];                                     % 87  k60  v60 forward,  v62 forward
parToReact{88} = [121];                                         % 88  k61  v61 forward
parToReact{89} = [];                                            % 89  RT
parToReact{90} = [];                                            % 90  c1
parToReact{91} = [];                                            % 91  c2
parToReact{92} = [];                                            % 92  c3

A = [];
constraintCount = 0;
parToReactMat = zeros(2*M,dim);
for index = 1:dim
    for paramIndex = 1:length(parToReact{index}) 
        reactNum = parToReact{index}(paramIndex);
        parToReactMat(reactNum,index) = 1;
    end
    for paramIndex = 2:length(parToReact{index}) 
        constraintCount = constraintCount + 1;
        cVect(constraintCount) = 0;
        A = [A;zeros(1,2*M)];
        A(constraintCount,parToReact{index}(paramIndex)) = 1;
        A(constraintCount,parToReact{index}(paramIndex-1)) = -1;
    end
end

reactToParamMat = zeros(dim,2*M);
for index = 1:M
    reactToForwParam{index} = find(parToReactMat((2*index)-1,:)>0); 
    if isempty(reactToForwParam{index}) 
        constraintCount = constraintCount + 1;
        A = [A;zeros(1,2*M)];
        A(constraintCount,2*index-1) = 1;
        cVect(constraintCount) = -1e3;
    elseif sum(reactToParamMat(reactToForwParam{index}(1),:),2)<1
        reactToParamMat(reactToForwParam{index}(1),(2*index)-1) = 1;
    end
    reactToBackParam{index} = find(parToReactMat(2*index,:)>0); 
    if isempty(reactToBackParam{index}) 
        constraintCount = constraintCount + 1;
        A = [A;zeros(1,2*M)];
        A(constraintCount,2*index) = 1;
        cVect(constraintCount) = -1e3;
    elseif sum(reactToParamMat(reactToBackParam{index}(1),:),2)<1
        reactToParamMat(reactToBackParam{index}(1),2*index)=1;
    end
end