% Find thermodynamic constraints
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%   Thermodynamically Consistent Model Calibration   %%%%%%%%%%%%
%%%%%%%%%%%              in Chemical Kinetics                  %%%%%%%%%%%%
%%%%%%%%%%%        THERMODYNAMICALLY CONSTRAINED MODEL         %%%%%%%%%%%%
%%%%%%%%%%%                    CALIBRATION                     %%%%%%%%%%%%
%%%%%%%%%%%            Authors: Jenkinson/Goutsias             %%%%%%%%%%%%
%%%%%%%%%%%             Last Modified: 12/02/2010              %%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Reorder stoichiometry matrix
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% Find closed subsystem 
%

reactionOrdering = [];
count = 0;

for react = 1:M
    if closedReaction(react)
        count = count+1;
        stoichClosed(:,count) = stoich(:,react);
        closedToFull(count)   = react; 
        reactionOrdering      = [reactionOrdering,react];
    end
end

%
% find linearly independent columns
%

[R,licols] = rref(stoichClosed);

%
% find linearly dependent columns
%

M1 = length(licols);   % rank(stoichClosed)
M2 = M0-M1;

ldcols = [];

for m = 1:M0
    if sum(licols==m) == 0
        ldcols = [ldcols m];
    end
end

%
% generate first permutation matrix
%

permMatM = eye(M0);
permMatM = [permMatM(:,licols),permMatM(:,ldcols)];

stoichM          = stoichClosed*permMatM;
reactionOrdering = reactionOrdering*permMatM;

%
% find linearly independent rows
%

[R,lirows] = rref(stoichM(:,1:length(licols))');

%
% find linearly dependent rows
%

ldrows = [];

for n = 1:Nd
    if sum(lirows==n) == 0
        ldrows = [ldrows n];
    end
end

%
% generate second permutation matrix
%

permMatN = eye(Nd);
permMatN = [permMatN(lirows,:);permMatN(ldrows,:)];

%
% final stoichiometery matrix in block form
%

Stoich_0Prime = permMatN*stoichM; 

%
% Remove species who are not involved in closed subsystem to find Stoich_0
%

Stoich_0 = Stoich_0Prime(sum(abs(Stoich_0Prime),2)>0,:);

N0 = size(Stoich_0,1) + 1; % EGF is involved in closed subsystem (clamping is removed)

%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Find thermodynamic constraints
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% Compute SS & W matrices
%

S11 = Stoich_0(1:M1,1:M1);
S12 = Stoich_0(1:M1,(M1+1):end);

SS = (inv(S11)*S12)';
W  = [-SS eye(M2) SS -eye(M2)];

S0_null = [-SS';eye(M2)];

%
% Reorder W matrix to full parameterization and add to A matrix
%

if ImposeThermoConst
    ordering = [2*reactionOrdering-1, 2*reactionOrdering];

    for index1 = 1:size(W,1)
        constraintCount = constraintCount + 1;
        A = [A;zeros(1,2*M)];
        cVect(constraintCount) = 0;
        for index2 = 1:length(ordering)
            A(constraintCount,ordering(index2)) = W(index1,index2);
        end
    end
end

cVect = cVect';

B = null(A);