% project published parameters
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%   Thermodynamically Consistent Model Calibration   %%%%%%%%%%%%
%%%%%%%%%%%              in Chemical Kinetics                  %%%%%%%%%%%%
%%%%%%%%%%%        THERMODYNAMICALLY CONSTRAINED MODEL         %%%%%%%%%%%%
%%%%%%%%%%%                    CALIBRATION                     %%%%%%%%%%%%
%%%%%%%%%%%            Authors: Jenkinson/Goutsias             %%%%%%%%%%%%
%%%%%%%%%%%             Last Modified: 12/02/2010              %%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%

function [logPublished,logStartingKappa] = ...
            findStartingKappa(parToReactMat,schoeberl,A,cVect)
                                  
logPublished = parToReactMat*log(schoeberl);

%
% remove redundant constraints
%

rrefMat = rref([A,cVect],1e-6);

Anew     = [];
cVectNew = [];
for row = 1:size(rrefMat,1)
    if sum(abs(rrefMat(row,:)),2) > 1e-6
        Anew = [Anew;rrefMat(row,1:(end-1))]; 
        cVectNew = [cVectNew;rrefMat(row,end)];
    end
end

%
% project log parameters onto the feasible manifold using closed-form 
% solution (constrained least-squares):
%

logStartingKappa = logPublished - Anew'*inv(Anew*Anew')*(Anew*logPublished-cVectNew);