% compute entropy production rates
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%   Thermodynamically Consistent Model Calibration   %%%%%%%%%%%%
%%%%%%%%%%%              in Chemical Kinetics                  %%%%%%%%%%%%
%%%%%%%%%%%        THERMODYNAMICALLY CONSTRAINED MODEL         %%%%%%%%%%%%
%%%%%%%%%%%                    CALIBRATION                     %%%%%%%%%%%%
%%%%%%%%%%%            Authors: Jenkinson/Goutsias             %%%%%%%%%%%%
%%%%%%%%%%%             Last Modified: 12/02/2010              %%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%

function [feasEPRs,infeasEPRs] = ... 
                     findEPRs(logKappaFinal,reactToParamMat,schoeberl,...
                              dim,lossKappaPubl,lossKappaFinal,...
                              ImposeThermoConst,S0_null,permMatM,kappaNames)

A  = 6.0221415e+23;   % Avogadro number (1/mol)
V  = 1e-15;           % system volume (m^3)
kb = 1.3806504e-23;   % Boltzman constant (J/K)

%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Find entropy production rates of published model
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%  

kappa  = schoeberl;

kappaPlus(:,1)   = kappa(2)*A*V;              
kappaMinus(:,1)  = kappa(3);               

kappaPlus(:,2)   = kappa(5)*A*V;               
kappaMinus(:,2)  = kappa(4);               

kappaPlus(:,3)   = kappa(6);              
kappaMinus(:,3)  = kappa(7);              

kappaPlus(:,4)   = kappa(8)*A*V;               
kappaMinus(:,4)  = kappa(9);               

kappaPlus(:,5)   = kappa(10);             
kappaMinus(:,5)  = kappa(11);              

kappaPlus(:,6)   = kappa(13)*A*V;              
kappaMinus(:,6)  = kappa(14);             

kappaPlus(:,7)   = kappa(15)*A*V;              
kappaMinus(:,7)  = kappa(16);             

kappaPlus(:,8)   = kappa(5)*A*V;               
kappaMinus(:,8)  = kappa(4);              

kappaPlus(:,9)   = kappa(6);               
kappaMinus(:,9)  = kappa(7);               

kappaPlus(:,10)  = kappa(22)*A*V;              
kappaMinus(:,10) = kappa(23);              

kappaPlus(:,11)  = kappa(26)*A*V;              
kappaMinus(:,11) = kappa(25);              

kappaPlus(:,12)  = kappa(28)*A*V;              
kappaMinus(:,12) = kappa(27);              

kappaPlus(:,13)  = kappa(30)*A*V;              
kappaMinus(:,13) = kappa(29);              

kappaPlus(:,14)  = kappa(34)*A*V;             
kappaMinus(:,14) = kappa(33);              

kappaPlus(:,15)  = kappa(37)*A*V;              
kappaMinus(:,15) = kappa(38);              

kappaPlus(:,16)  = kappa(39);              
kappaMinus(:,16) = kappa(40);              

kappaPlus(:,17)  = kappa(41)*A*V;          
kappaMinus(:,17) = kappa(42);              

kappaPlus(:,18)  = kappa(44)*A*V;             
kappaMinus(:,18) = kappa(43);              

kappaPlus(:,19)  = kappa(30)*A*V;              
kappaMinus(:,19) = kappa(29);              

kappaPlus(:,20)  = kappa(45)*A*V;             
kappaMinus(:,20) = kappa(46);             

kappaPlus(:,21)  = kappa(47);           
kappaMinus(:,21) = kappa(48)*A*V;             

kappaPlus(:,22)  = kappa(34)*A*V;             
kappaMinus(:,22) = kappa(33);            

kappaPlus(:,23)  = kappa(50);           
kappaMinus(:,23) = kappa(49)*A*V;             

kappaPlus(:,24)  = kappa(51);             
kappaMinus(:,24) = kappa(52)*A*V;             

kappaPlus(:,25)  = kappa(53);         
kappaMinus(:,25) = kappa(54)*A*V;             

kappaPlus(:,26)  = kappa(55);              
kappaMinus(:,26) = kappa(56)*A*V;              

kappaPlus(:,27)  = kappa(59);              
kappaMinus(:,27) = kappa(60)*A*V;              

kappaPlus(:,28)  = kappa(41)*A*V;             
kappaMinus(:,28) = kappa(42);             

kappaPlus(:,29)  = kappa(59);              
kappaMinus(:,29) = kappa(60)*A*V;              

kappaPlus(:,30)  = kappa(61)*A*V;             
kappaMinus(:,30) = kappa(62);            

kappaPlus(:,31)  = kappa(64)*A*V;            
kappaMinus(:,31) = kappa(63);            

kappaPlus(:,32)  = kappa(65)*A*V;             
kappaMinus(:,32) = kappa(66);            

kappaPlus(:,33)  = kappa(69)*A*V;            
kappaMinus(:,33) = kappa(68);             

kappaPlus(:,34)  = kappa(69)*A*V;             
kappaMinus(:,34) = kappa(68);          

kappaPlus(:,35)  = kappa(73)*A*V;            
kappaMinus(:,35) = kappa(72);             

kappaPlus(:,36)  = kappa(76)*A*V;            
kappaMinus(:,36) = kappa(75);             

kappaPlus(:,37)  = kappa(77)*A*V;             
kappaMinus(:,37) = kappa(78);             

kappaPlus(:,38)  = kappa(77)*A*V;             
kappaMinus(:,38) = kappa(78);             

kappaPlus(:,39)  = kappa(82)*A*V;             
kappaMinus(:,39) = kappa(81);           

kappaPlus(:,40)  = kappa(85)*A*V;           
kappaMinus(:,40) = kappa(84);          

kappaPlus(:,41)  = kappa(26)*A*V;        
kappaMinus(:,41) = kappa(25);          

kappaPlus(:,42)  = kappa(28)*A*V;        
kappaMinus(:,42) = kappa(27);         

kappaPlus(:,43)  = kappa(30)*A*V;          
kappaMinus(:,43) = kappa(29);          

kappaPlus(:,44)  = kappa(34)*A*V;          
kappaMinus(:,44) = kappa(33);         

kappaPlus(:,45)  = kappa(37)*A*V;         
kappaMinus(:,45) = kappa(38);         

kappaPlus(:,46)  = kappa(39);            
kappaMinus(:,46) = kappa(40);           

kappaPlus(:,47)  = kappa(41)*A*V;            
kappaMinus(:,47) = kappa(42);             

kappaPlus(:,48)  = kappa(44)*A*V;         
kappaMinus(:,48) = kappa(43);         

kappaPlus(:,49)  = kappa(30)*A*V;           
kappaMinus(:,49) = kappa(29);            

kappaPlus(:,50)  = kappa(45)*A*V;          
kappaMinus(:,50) = kappa(46);           

kappaPlus(:,51)  = kappa(47);            
kappaMinus(:,51) = kappa(48)*A*V;            

kappaPlus(:,52)  = kappa(34)*A*V;            
kappaMinus(:,52) = kappa(33);            

kappaPlus(:,53)  = kappa(50);           
kappaMinus(:,53) = kappa(49)*A*V;           

kappaPlus(:,54)  = kappa(53);          
kappaMinus(:,54) = kappa(54)*A*V;         

kappaPlus(:,55)  = kappa(59);          
kappaMinus(:,55) = kappa(60)*A*V;         

kappaPlus(:,56)  = kappa(59);         
kappaMinus(:,56) = kappa(60)*A*V;         

kappaPlus(:,57)  = kappa(64)*A*V;             
kappaMinus(:,57) = kappa(63);            

kappaPlus(:,58)  = kappa(65)*A*V;             
kappaMinus(:,58) = kappa(66);             

kappaPlus(:,59)  = kappa(69)*A*V;             
kappaMinus(:,59) = kappa(68);             

kappaPlus(:,60)  = kappa(69)*A*V;             
kappaMinus(:,60) = kappa(68);             

kappaPlus(:,61)  = kappa(73)*A*V;             
kappaMinus(:,61) = kappa(72);             

kappaPlus(:,62)  = kappa(76)*A*V;             
kappaMinus(:,62) = kappa(75);             

kappaPlus(:,63)  = kappa(77)*A*V;             
kappaMinus(:,63) = kappa(78);             

kappaPlus(:,64)  = kappa(77)*A*V;             
kappaMinus(:,64) = kappa(78);             

kappaPlus(:,65)  = kappa(82)*A*V;             
kappaMinus(:,65) = kappa(81);             

kappaPlus(:,66)  = kappa(85)*A*V;             
kappaMinus(:,66) = kappa(84);             

kappaPlus(:,67)  = kappa(10);             
kappaMinus(:,67) = kappa(11);             

kappaPlus(:,68)  = kappa(10);             
kappaMinus(:,68) = kappa(11);             

kappaPlus(:,69)  = kappa(10);             
kappaMinus(:,69) = kappa(11);             

kappaPlus(:,70)  = kappa(10);             
kappaMinus(:,70) = kappa(11);              

kappaPlus(:,71)  = kappa(8)*A*V;              
kappaMinus(:,71) = kappa(9);              

kappaPlus(:,72)  = kappa(10);             
kappaMinus(:,72) = kappa(11);             

kappaPlus(:,73)  = kappa(8)*A*V;              
kappaMinus(:,73) = kappa(9);              

kappaPlus(:,74)  = kappa(10);             
kappaMinus(:,74) = kappa(11);             

kappaPlus(:,75)  = kappa(8)*A*V;              
kappaMinus(:,75) = kappa(9);              

kappaPlus(:,76)  = kappa(10);             
kappaMinus(:,76) = kappa(11);             

kappaPlus(:,77)  = kappa(8)*A*V;              
kappaMinus(:,77) = kappa(9);              

kappaPlus(:,78)  = kappa(10);             
kappaMinus(:,78) = kappa(11);             

kappaPlus(:,79)  = kappa(8)*A*V;              
kappaMinus(:,79) = kappa(9);              

kappaPlus(:,80)  = kappa(10);             
kappaMinus(:,80) = kappa(11);             
 
kappaPlus(:,81)  = kappa(8)*A*V;              
kappaMinus(:,81) = kappa(9);              

kappaPlus(:,82)  = kappa(10);             
kappaMinus(:,82) = kappa(11);             

kappaPlus(:,83)  = kappa(8)*A*V;              
kappaMinus(:,83) = kappa(9);                    

%
% reorder reactions to use closed form solution to basis
%

kappaPlusOrdered  = kappaPlus*permMatM;
kappaMinusOrdered = kappaMinus*permMatM; 

%
% compute entropy production rates
%

infeasEPRs = (A*V*kb).*log(kappaPlusOrdered./kappaMinusOrdered)*S0_null;

%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Find entropy production rates of estimated model
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%  


params = reactToParamMat*exp(logKappaFinal);

for index = 1:dim
    if params(index) > 0
        kappa(index) = params(index);
    end
end


kappaPlus(:,1)   = kappa(2)*A*V;              
kappaMinus(:,1)  = kappa(3);               

kappaPlus(:,2)   = kappa(5)*A*V;               
kappaMinus(:,2)  = kappa(4);               

kappaPlus(:,3)   = kappa(6);              
kappaMinus(:,3)  = kappa(7);              

kappaPlus(:,4)   = kappa(8)*A*V;               
kappaMinus(:,4)  = kappa(9);               

kappaPlus(:,5)   = kappa(10);             
kappaMinus(:,5)  = kappa(11);              

kappaPlus(:,6)   = kappa(13)*A*V;              
kappaMinus(:,6)  = kappa(14);             

kappaPlus(:,7)   = kappa(15)*A*V;              
kappaMinus(:,7)  = kappa(16);             

kappaPlus(:,8)   = kappa(5)*A*V;               
kappaMinus(:,8)  = kappa(4);              

kappaPlus(:,9)   = kappa(6);               
kappaMinus(:,9)  = kappa(7);               

kappaPlus(:,10)  = kappa(22)*A*V;              
kappaMinus(:,10) = kappa(23);              

kappaPlus(:,11)  = kappa(26)*A*V;              
kappaMinus(:,11) = kappa(25);              

kappaPlus(:,12)  = kappa(28)*A*V;              
kappaMinus(:,12) = kappa(27);              

kappaPlus(:,13)  = kappa(30)*A*V;              
kappaMinus(:,13) = kappa(29);              

kappaPlus(:,14)  = kappa(34)*A*V;             
kappaMinus(:,14) = kappa(33);              

kappaPlus(:,15)  = kappa(37)*A*V;              
kappaMinus(:,15) = kappa(38);              

kappaPlus(:,16)  = kappa(39);              
kappaMinus(:,16) = kappa(40);              

kappaPlus(:,17)  = kappa(41)*A*V;          
kappaMinus(:,17) = kappa(42);              

kappaPlus(:,18)  = kappa(44)*A*V;             
kappaMinus(:,18) = kappa(43);              

kappaPlus(:,19)  = kappa(30)*A*V;              
kappaMinus(:,19) = kappa(29);              

kappaPlus(:,20)  = kappa(45)*A*V;             
kappaMinus(:,20) = kappa(46);             

kappaPlus(:,21)  = kappa(47);           
kappaMinus(:,21) = kappa(48)*A*V;             

kappaPlus(:,22)  = kappa(34)*A*V;             
kappaMinus(:,22) = kappa(33);            

kappaPlus(:,23)  = kappa(50);           
kappaMinus(:,23) = kappa(49)*A*V;             

kappaPlus(:,24)  = kappa(51);             
kappaMinus(:,24) = kappa(52)*A*V;             

kappaPlus(:,25)  = kappa(53);         
kappaMinus(:,25) = kappa(54)*A*V;             

kappaPlus(:,26)  = kappa(55);              
kappaMinus(:,26) = kappa(56)*A*V;              

kappaPlus(:,27)  = kappa(59);              
kappaMinus(:,27) = kappa(60)*A*V;              

kappaPlus(:,28)  = kappa(41)*A*V;             
kappaMinus(:,28) = kappa(42);             

kappaPlus(:,29)  = kappa(59);              
kappaMinus(:,29) = kappa(60)*A*V;              

kappaPlus(:,30)  = kappa(61)*A*V;             
kappaMinus(:,30) = kappa(62);            

kappaPlus(:,31)  = kappa(64)*A*V;            
kappaMinus(:,31) = kappa(63);            

kappaPlus(:,32)  = kappa(65)*A*V;             
kappaMinus(:,32) = kappa(66);            

kappaPlus(:,33)  = kappa(69)*A*V;            
kappaMinus(:,33) = kappa(68);             

kappaPlus(:,34)  = kappa(69)*A*V;             
kappaMinus(:,34) = kappa(68);          

kappaPlus(:,35)  = kappa(73)*A*V;            
kappaMinus(:,35) = kappa(72);             

kappaPlus(:,36)  = kappa(76)*A*V;            
kappaMinus(:,36) = kappa(75);             

kappaPlus(:,37)  = kappa(77)*A*V;             
kappaMinus(:,37) = kappa(78);             

kappaPlus(:,38)  = kappa(77)*A*V;             
kappaMinus(:,38) = kappa(78);             

kappaPlus(:,39)  = kappa(82)*A*V;             
kappaMinus(:,39) = kappa(81);           

kappaPlus(:,40)  = kappa(85)*A*V;           
kappaMinus(:,40) = kappa(84);          

kappaPlus(:,41)  = kappa(26)*A*V;        
kappaMinus(:,41) = kappa(25);          

kappaPlus(:,42)  = kappa(28)*A*V;        
kappaMinus(:,42) = kappa(27);         

kappaPlus(:,43)  = kappa(30)*A*V;          
kappaMinus(:,43) = kappa(29);          

kappaPlus(:,44)  = kappa(34)*A*V;          
kappaMinus(:,44) = kappa(33);         

kappaPlus(:,45)  = kappa(37)*A*V;         
kappaMinus(:,45) = kappa(38);         

kappaPlus(:,46)  = kappa(39);            
kappaMinus(:,46) = kappa(40);           

kappaPlus(:,47)  = kappa(41)*A*V;            
kappaMinus(:,47) = kappa(42);             

kappaPlus(:,48)  = kappa(44)*A*V;         
kappaMinus(:,48) = kappa(43);         

kappaPlus(:,49)  = kappa(30)*A*V;           
kappaMinus(:,49) = kappa(29);            

kappaPlus(:,50)  = kappa(45)*A*V;          
kappaMinus(:,50) = kappa(46);           

kappaPlus(:,51)  = kappa(47);            
kappaMinus(:,51) = kappa(48)*A*V;            

kappaPlus(:,52)  = kappa(34)*A*V;            
kappaMinus(:,52) = kappa(33);            

kappaPlus(:,53)  = kappa(50);           
kappaMinus(:,53) = kappa(49)*A*V;           

kappaPlus(:,54)  = kappa(53);          
kappaMinus(:,54) = kappa(54)*A*V;         

kappaPlus(:,55)  = kappa(59);          
kappaMinus(:,55) = kappa(60)*A*V;         

kappaPlus(:,56)  = kappa(59);         
kappaMinus(:,56) = kappa(60)*A*V;         

kappaPlus(:,57)  = kappa(64)*A*V;             
kappaMinus(:,57) = kappa(63);            

kappaPlus(:,58)  = kappa(65)*A*V;             
kappaMinus(:,58) = kappa(66);             

kappaPlus(:,59)  = kappa(69)*A*V;             
kappaMinus(:,59) = kappa(68);             

kappaPlus(:,60)  = kappa(69)*A*V;             
kappaMinus(:,60) = kappa(68);             

kappaPlus(:,61)  = kappa(73)*A*V;             
kappaMinus(:,61) = kappa(72);             

kappaPlus(:,62)  = kappa(76)*A*V;             
kappaMinus(:,62) = kappa(75);             

kappaPlus(:,63)  = kappa(77)*A*V;             
kappaMinus(:,63) = kappa(78);             

kappaPlus(:,64)  = kappa(77)*A*V;             
kappaMinus(:,64) = kappa(78);             

kappaPlus(:,65)  = kappa(82)*A*V;             
kappaMinus(:,65) = kappa(81);             

kappaPlus(:,66)  = kappa(85)*A*V;             
kappaMinus(:,66) = kappa(84);             

kappaPlus(:,67)  = kappa(10);             
kappaMinus(:,67) = kappa(11);             

kappaPlus(:,68)  = kappa(10);             
kappaMinus(:,68) = kappa(11);             

kappaPlus(:,69)  = kappa(10);             
kappaMinus(:,69) = kappa(11);             

kappaPlus(:,70)  = kappa(10);             
kappaMinus(:,70) = kappa(11);              

kappaPlus(:,71)  = kappa(8)*A*V;              
kappaMinus(:,71) = kappa(9);              

kappaPlus(:,72)  = kappa(10);             
kappaMinus(:,72) = kappa(11);             

kappaPlus(:,73)  = kappa(8)*A*V;              
kappaMinus(:,73) = kappa(9);              

kappaPlus(:,74)  = kappa(10);             
kappaMinus(:,74) = kappa(11);             

kappaPlus(:,75)  = kappa(8)*A*V;              
kappaMinus(:,75) = kappa(9);              

kappaPlus(:,76)  = kappa(10);             
kappaMinus(:,76) = kappa(11);             

kappaPlus(:,77)  = kappa(8)*A*V;              
kappaMinus(:,77) = kappa(9);              

kappaPlus(:,78)  = kappa(10);             
kappaMinus(:,78) = kappa(11);             

kappaPlus(:,79)  = kappa(8)*A*V;              
kappaMinus(:,79) = kappa(9);              

kappaPlus(:,80)  = kappa(10);             
kappaMinus(:,80) = kappa(11);             
 
kappaPlus(:,81)  = kappa(8)*A*V;              
kappaMinus(:,81) = kappa(9);              

kappaPlus(:,82)  = kappa(10);             
kappaMinus(:,82) = kappa(11);             

kappaPlus(:,83)  = kappa(8)*A*V;              
kappaMinus(:,83) = kappa(9);                

%
% reorder reactions to use closed form solution to basis
%

kappaPlusOrdered  = kappaPlus*permMatM;
kappaMinusOrdered = kappaMinus*permMatM; 

%
% compute entropy production rates
%

feasEPRs = (A*V*kb).*log(kappaPlusOrdered./kappaMinusOrdered)*S0_null;

%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Remove values that are under matlab's numerical precision
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%  

orderOfMag = log10(eps(A*V*kb)); % the smallest number matlab can express

%
% if values are within 2 orders of magnitude of the minimum numerical 
% precision of matlab, we take them to be 0
%

feasEPRs(log10(abs(feasEPRs))<=orderOfMag+2) = 0;
infeasEPRs(log10(abs(infeasEPRs))<=orderOfMag+2) = 0;

%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Write results to file
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%  


if ImposeThermoConst
fid = fopen('results/reports/tcmcparams.txt', 'w');
fprintf(fid,'Parameter Name       Published Value      TCMC Value\n');
else
fid = fopen('results/reports/estparams.txt', 'w');
fprintf(fid,'Parameter Name       Published Value      Estimated Value\n');
end

fprintf(fid,'---------------------------------------------------------\n');

for index = [2:16,21:(dim-4)]
fprintf(fid,'%5s                %12.6E         %12.6E\n',kappaNames{index},schoeberl(index),kappa(index));
end
fclose(fid);

if ImposeThermoConst
    fid = fopen('results/reports/tcmc.txt', 'w');
else
    fid = fopen('results/reports/estimated.txt', 'w');
end

if ImposeThermoConst
    fprintf(fid,'------------------------- \n');
    fprintf(fid,'TCMC EGF/ERK MODEL \n');
    fprintf(fid,'------------------------- \n\n');
    fprintf(fid,'Cost of TCMC model = %6.2E\n\n',lossKappaFinal);
    fprintf(fid,'Cycle             EPR [in J/(K.min)] \n');
    fprintf(fid,'------------------------------------------------ \n');
    for index = 1:size(S0_null,2)
        fprintf(fid, '%2i                 %+6.2E\n', index, feasEPRs(index));
    end
else
 fprintf(fid,'------------------------- \n');
    fprintf(fid,'ESTIMATED EGF/ERK MODEL \n');
    fprintf(fid,'------------------------- \n\n');
    fprintf(fid,'Cost of estimated model = %6.2E\n\n',lossKappaFinal);
    fprintf(fid,'Cycle             EPR [in J/(K.min)] \n');
    fprintf(fid,'------------------------------------------------ \n');
    for index = 1:size(S0_null,2)
        fprintf(fid, '%2i                 %+6.2E\n', index, feasEPRs(index));
    end 
end

fprintf(fid,'\n\n\n\n------------------------ \n');
fprintf(fid,'PUBLISHED EGF/ERK MODEL \n');
fprintf(fid,'------------------------ \n\n');
fprintf(fid,'Cost of published model = %6.2E\n\n',lossKappaPubl);
fprintf(fid,'Cycle             EPR [in J/(K.min)] \n');
fprintf(fid,'------------------------------------------------ \n');
for index = 1:size(S0_null,2)
    fprintf(fid, '%2i                 %+6.2E\n', index, infeasEPRs(index));
end

fclose(fid);

