% verify EGF/ERK model
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%   Thermodynamically Consistent Model Calibration   %%%%%%%%%%%%
%%%%%%%%%%%               in Chemical Kinetics                 %%%%%%%%%%%%
%%%%%%%%%%%                MODEL VERIFICATION                  %%%%%%%%%%%%
%%%%%%%%%%%            Authors: Jenkinson/Goutsias             %%%%%%%%%%%%
%%%%%%%%%%%             Last Modified: 12/02/2010              %%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% This script verifies that the SBML file of the EGF/ERK Schroeberl model,  
% obtained from the BioModels database and the Systems Biology Toolbox for 
% Matlab, reproduces the curated results found in the BioModels database.
%

modelObj = SBmodel('BIOMD0000000019.xml');

SBPDmakeMEXmodel(modelObj)

%
% Get parameter values
%

[kappaNames,initialKappa] = SBparameters(modelObj);

%
% Get initial conditions
%

x0_EGF = [4962; 49.6; 12.4]; % three published EGF stimuli 

initialCond = SBinitialconditions(modelObj);   % all ICs stored in model

%
% Run simulation
%

time = 0:0.1:60;   % set simulation time

initialKappa(1) = x0_EGF(1);
output1         = Schoeberl2002_EGF_MAPK(time,initialCond,initialKappa);

initialKappa(1) = x0_EGF(2);
output2         = Schoeberl2002_EGF_MAPK(time,initialCond,initialKappa);

initialKappa(1) = x0_EGF(3);
output3         = Schoeberl2002_EGF_MAPK(time,initialCond,initialKappa);

%
% Display curated results
%

[I,map,alpha] = imread('curated.png','png');

figure;
image(I)
colormap(map)

%
% Plot simulation results
%

figure;
subplot(2,2,1), plot(output1.time,output1.variablevalues(:,3),'r'); hold on;
subplot(2,2,1), plot(output2.time,output2.variablevalues(:,3),'b'); hold on;
subplot(2,2,1), plot(output3.time,output3.variablevalues(:,3),'g'); 
axis([0,60,0,1.2e7]);title('ERK-PP')

subplot(2,2,2), plot(output1.time,output1.variablevalues(:,2),'r'); hold on;
subplot(2,2,2), plot(output2.time,output2.variablevalues(:,2),'b'); hold on;
subplot(2,2,2), plot(output3.time,output3.variablevalues(:,2),'g'); 
axis([0,60,0,2e5]);title('MEK-PP')

subplot(2,2,3), plot(output1.time,output1.variablevalues(:,4),'r'); hold on;
subplot(2,2,3), plot(output2.time,output2.variablevalues(:,4),'b'); hold on;
subplot(2,2,3), plot(output3.time,output3.variablevalues(:,4),'g'); 
axis([0,60,0,20000]);title('Raf*')

subplot(2,2,4), plot(output1.time,output1.variablevalues(:,1),'r'); hold on;
subplot(2,2,4), plot(output2.time,output2.variablevalues(:,1),'b'); hold on;
subplot(2,2,4), plot(output3.time,output3.variablevalues(:,1),'g'); 
axis([0,60,0,20000]);title('Ras-GTP')

delete('Schoeberl2002_EGF_MAPK.mexw32')