% verify EGF/ERK model
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%   Thermodynamically Consistent Model Calibration   %%%%%%%%%%%%
%%%%%%%%%%%               in Chemical Kinetics                 %%%%%%%%%%%%
%%%%%%%%%%%                MODEL VERIFICATION                  %%%%%%%%%%%%
%%%%%%%%%%%            Authors: Jenkinson/Goutsias             %%%%%%%%%%%%
%%%%%%%%%%%             Last Modified: 4/07/2011               %%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% This script verifies that the SBML file of the EGF/ERK Schroeberl model,  
% obtained from the BioModels database and the Systems Biology Toolbox for 
% Matlab, reproduces the curated results found in the BioModels database.
%

modelObj = SBmodel('TCMC.xml');

SBPDmakeMEXmodel(modelObj)

%
% Get parameter values
%

[kappaNames,initialKappa] = SBparameters(modelObj);

A  = 6.0221415e+23;   % Avogadro number (1/mol)
V  = 1e-15;           % system volume (m^3)  

%
% Get initial conditions
%

x0_EGF = [4962; 496.2; 49.6; 12.4; 6.2]; % five published EGF stimuli 

initialCond = SBinitialconditions(modelObj);   % all ICs stored in model

%
% Run simulation
%

time = 0:0.1:60;   % set simulation time

initialKappa(1) = x0_EGF(1);
output1         = JenkinsonGoutsias2011_EGF_MAPK(time,initialCond,initialKappa);

initialKappa(1) = x0_EGF(2);
output2         = JenkinsonGoutsias2011_EGF_MAPK(time,initialCond,initialKappa);

initialKappa(1) = x0_EGF(3);
output3         = JenkinsonGoutsias2011_EGF_MAPK(time,initialCond,initialKappa);

initialKappa(1) = x0_EGF(4);
output4         = JenkinsonGoutsias2011_EGF_MAPK(time,initialCond,initialKappa);

initialKappa(1) = x0_EGF(5);
output5         = JenkinsonGoutsias2011_EGF_MAPK(time,initialCond,initialKappa);

%
% Plot simulation results
%

figure;
plot(output1.time,output1.variablevalues(:,3)/(A*V),'r'); hold on;
plot(output2.time,output2.variablevalues(:,3)/(A*V),'b'); hold on;
plot(output3.time,output3.variablevalues(:,3)/(A*V),'g'); hold on;
plot(output3.time,output4.variablevalues(:,3)/(A*V),'k'); hold on;
plot(output3.time,output5.variablevalues(:,3)/(A*V),'y'); hold on;
axis([0,60,0,.02]);title('ERK-PP (TCMC)')
legend('50 ng/mL EGF','5 ng/mL EGF','0.5 ng/mL EGF','0.125 ng/mL EGF','0.0625 ng/mL EGF')

%
% Display curated results
%

[I,map,alpha] = imread('curated1.png','png');

figure;
image(I)
colormap(map)

[I,map,alpha] = imread('curated2.png','png');

figure;
image(I)
colormap(map)

delete('JenkinsonGoutsias2011_EGF_MAPK.mexw32')