% show_paraRIEValidation.m
%  This code is to show the RIE (Rand Index Estimator) as a function of lambda and gamma.
%  
%   a) Given a search set for each of lambda and gamma;
%   b) For each case, perform CS3C with a pair of (lambda, gamma) and evaluate the Rand Index Estimator (RIE);
%   c) Show the function RIE(lambda, gamma);
%   d) Find the (lambda, gamma) with the best RIE.
%
%  Use: 
%           h=figure;show_paraRIEValidation(lambda_arr, gamma_arr, RIE, 'RIE', h, 'hot', 'imagesc');
%           h=figure;show_paraRIEValidation(lambda_arr, gamma_arr, ERR, 'ERR', h, 'hot', 'imagesc');
%
% CHUNGUANG LI
% May 12, 2015; Revised July 28, 2017.
function []=show_paraRIEValidation(lambda_arr, gamma_arr, RIE, strTitle, h, strColormap, toShowStyle)
%
if (nargin < 4)
    strTitle = 'RIE'; 
end
if (nargin < 5)
    h = figure; 
end
if (nargin < 6)
    strColormap = 'jet'; 
end
if (nargin < 7)
    toShowStyle = 'imagesc'; 
end
%% Show MC ERR OUT
figure(h); 
colormap(strColormap);
if strcmp(toShowStyle, 'imagesc')
    imagesc(RIE(:,:,1,1)); 
else
    surf(RIE(:,:,1,1)); 
end
xlabel('\gamma'); % xlabel('\alpha');
%ylabel('$\frac{k d}{ n}$','interpreter','latex');
ylabel('\lambda'); % ylabel('\lambda_0');
xlim([1 length(gamma_arr)]);
XTickLabel= gamma_arr;

set(gca,'XTickLabel',XTickLabel,'XLimMode','manual');
ylim([1 length(lambda_arr)]);
YTickLabel= lambda_arr;
set(gca,'YTickLabel', YTickLabel,'YLimMode','manual');
zlabel(strTitle);
colorbar;

% figure; 
% colormap jet;
% surf(MC_ERR(:,:,1,1));
% ylabel('\gamma');
% %ylabel('$\frac{k d}{ n}$','interpreter','latex');
% xlabel('\lambda');
% XTickLabel= lambda_arr;
% set(gca,'XTickLabel',XTickLabel,'XLimMode','manual');
% YTickLabel= gamma_arr;
% set(gca,'YTickLabel', YTickLabel,'YLimMode','manual');
% zlabel('MC ERR (%)');
% colorbar;

% figure; 
% colormap hot;
% surf(ACC(:,:,1,1));
% ylabel('\gamma');
% %ylabel('$\frac{k d}{ n}$','interpreter','latex');
% xlabel('\lambda');
% XTickLabel= lambda_arr;
% set(gca,'XTickLabel',XTickLabel,'XLimMode','manual');
% YTickLabel= gamma_arr;
% set(gca,'YTickLabel', YTickLabel,'YLimMode','manual');
% zlabel('ACC (%)');
% colorbar;

