% run_S3C_MotionSegmentation.m
%--------------------------------------------------------------------------
% This is the main function to run the SSC algorithm for the motion
% segmentation problem on the Hopkins 155 dataset.
%
% cd to the main folder containing the Hopkins 155 sequences
% add the path to the folder "SSC_motion_face" containing these m-files
%
% avgmissrate1: the n-th element contains the average clustering error for 
% sequences with n motions (using 2F-dimensional data)
% avgmissrate2: the n-th element contains the average clustering error for 
% sequences with n motions (using 4n-dimensional data)
% medmissrate1: the n-th element contains the median clustering error for 
% sequences with n motions (using 2F-dimensional data)
% medmissrate2: the n-th element contains the median clustering error for 
% sequences with n motions (using 4n-dimensional data)
%--------------------------------------------------------------------------
% Copyright @ Ehsan Elhamifar, 2012
% Modified by C.-G. Li, Feb.12, 2014
% Changed by Chunguang Li Nov.5, 2014
%-------------------------------------------------------------------------
clc;
clear all;
close all;
% addpath('../../lrr');
% addpath('../../inexact_ladm_mc');
% addpath('../../local_comp_represent');
% addpath('../../inexact_alm_mc/PROPACK');
% addpath('../../inexact_alm_mc');
% addpath('./');
% addpath('../SSC_ADMM_v1.1');
%addpath('../../CodeLSA');
%addpath('../../CodeLSA/helper_functions');

Debug =0;

% addpath('../Hopkins155_Add_Seq_MissingData');
cd '../Hopkins155'; results_fn =['_Tmax10_MS_seq155_results_',datestr(now,30),'.mat'];
alpha = 800;
    
maxNumGroup = 5;
for i = 1:maxNumGroup
    num(i) = 0;
end
tic
n_seq  =0;
d = dir;
for i = 1:length(d)
    if ( (d(i).isdir == 1) && ~strcmp(d(i).name,'.') && ~strcmp(d(i).name,'..') )
        filepath = d(i).name;
        eval(['cd ' filepath]);
        
        f = dir;
        foundValidData = false;
        for j = 1:length(f)
            if ( ~isempty(strfind(f(j).name,'_truth.mat')) )
                ind = j;
                foundValidData = true;
                break
            end
        end
        eval(['load ' f(ind).name]);
        cd ..
        
        if (foundValidData)
            n_seq = n_seq +1;
            disp(['############# Sequence: ', num2str(n_seq)]);
            
            n = max(s);
            N = size(x,2);
            F = size(x,3);
            D = 2*F;
            X = reshape(permute(x(1:2,:,:),[1 3 2]),D,N);
            
            if (Debug ==1)
                idx =1:size(X,2);
                %Ns = size(X,2);
                Ns =min(150, size(X,2)); % 150
                X =X(1:30, idx(1:Ns));%12
                s =s(idx(1:Ns));              
            end
            
%             %% 1. SSC
%             r=0; %r = 12; 
%             affine = true; 
%             outlier = false; 
%             %outlier = true; 
%             rho= 1.0;
%             [missrate1,C1] = SSC(X,r,affine,alpha,outlier,rho,s);
%             disp(['------------------------- - - # Sequence: ', num2str(n_seq)]);
%             disp(['* * * SSC missrate  1: ', num2str(missrate1)]);    
%             disp(['------------------------']);
            
            
            %% 2.  soft S3C        
                    
%             opt.sc_method ='softStrSSC2+'; gamma0 =0.20;                        
%             opt.sc_method ='softStrSSC-Fix2'; gamma0 =0.12;                       
%             opt.sc_method ='softStrSSC-Up2+'; gamma0 =0.10;                       
%             opt.sc_method ='StrSSC-Fix2'; gamma0 =0.02;                         
%             opt.sc_method ='StrSSC-Up2'; gamma0 =0.02;                              
%             opt.sc_method ='StrSSC2'; gamma0 =0.02;        
            
%             opt.sc_method ='StrSSC2+'; gamma0 =0.02;                      
%             opt.sc_method ='StrSSC-Fix2+'; gamma0 =0.02;     
%             opt.sc_method ='StrSSC-Up2+'; gamma0 =0.02;
%                                 
%             opt.sc_method ='softStrSSC-Fix2+'; gamma0 =0.12;  
%             opt.sc_method ='softStrSSC2+'; gamma0 =0.20; 
            opt.sc_method ='softStrSSC-Up2+'; gamma0 =0.10;    
            
            opt.affine =1;              
            opt.outliers =0;
            
            opt.T =1;% T=1 for spectral clustering and T>2 for spectral assumble clustering
            opt.iter_max =10; %  iter_max is for T_max
            opt.nu =1;

            opt.gamma0 =gamma0;% This is for reweighting the off-diagonal entries in Z
            opt.lambda =alpha;
            opt.r =0;

            opt.mu_max = 1e8;
            opt.tol =1e-5;
            opt.rho=1.1;
            opt.maxIter =150;

            opt.error_norm ='L1'; % 'L1'
            opt.SSCrho=1.0; %rho = 0.7;
            opt.DEBUG =0;

            [missrate1] = StrSSCplus(X, s', opt);            
            disp(['------------------------- - - # Sequence: ', num2str(n_seq)]);
            disp(['* * *', opt.sc_method, ': missrate : ', num2str(1-missrate1)]);    
            disp(['------------------------']);         
                                                             
            num(n) = num(n) + 1;
            missrateTot1{n}(num(n)) = missrate1;  
            
            eval(['cd ' filepath]);
            cd ..
        end   
    end
end
times_cost =toc;
results_fn = [opt.sc_method, results_fn];
save(results_fn, 'missrateTot1', 'opt', 'times_cost'); 

num_gamma =1;
ACC =zeros(9, num_gamma);
for ii =1:num_gamma
    % two motion: mean / median / std
     ACC(1, ii) =100-100*mean([ missrateTot1{ii,2}]);
     ACC(2, ii) =100-100*median([ missrateTot1{ii,2}]);
     ACC(3, ii) =100*std([ missrateTot1{ii,2}]);
    disp(['two motion: mean / med / std']);
    disp(num2str(ACC(1:3, ii)));

    % three motion: mean / median / std    
     ACC(4, ii) =100-100*mean([ missrateTot1{ii,3}]);
     ACC(5, ii) =100-100*median([ missrateTot1{ii,3}]);
     ACC(6, ii) =100*std([ missrateTot1{ii,3}]);
    disp(['three motion: mean / med / std']);
    disp(num2str(ACC(4:6, ii)));
     
    % total: mean / median / std    
     ACC(7, ii) =100-100*mean([missrateTot1{ii,3}, missrateTot1{ii,2}]);
     ACC(8, ii) =100-100*median([missrateTot1{ii,3}, missrateTot1{ii,2}]);
     ACC(9, ii) =100*std([missrateTot1{ii,3}, missrateTot1{ii,2}]);
    disp(['total: mean / med / std']);disp(num2str(ACC(7:9, ii)))
end