% run_S3C_ExtendedYaleB_face.m
%
% Modified by C.-G. Li:
% Feb.12, 2014; Nov.5, 2014; July 15, 2017
clc;
% clear all;
% close all;
clear all, close all

addpath('./data');
load YaleBCrop025.mat
filename =['_ExtendedYaleB_results',datestr(now,30),'.mat'];
alpha = 20;

nSet = [2 3 5 8 10];
for i = 1:length(nSet)    
    n = nSet(i);
    idx = Ind{n};   
    for j = 1:size(idx,1)
        X = [];
        for p = 1:n
            X = [X Y(:,:,idx(j,p))];
        end
        [D,N] = size(X);
       
        tic
        disp(['For number of clusters n =  ', num2str(n),':  There are totally ', num2str(size(idx,1)), ' cases. ']);
        
        %% 1. SSC
        r = 0; affine = false; outlier = true; rho = 1;
        [missrate1,C] = SSC(X,r,affine,alpha,outlier,rho,s{n});
        missrateTot1{n}(j) = missrate1;        
        disp(['------------------------- - - n =  ', num2str(n),', j = ', num2str(j), ' of  ', num2str(size(idx,1))]);
        disp(['* * * SSC missrate 1: ', num2str( missrate1)]);

         %% 2. S3C:                   
%         opt.sc_method ='StrSSC-Fix2+'; gamma0 =0.1; % softS3c works in the range: 0.05 to 0.3
%         opt.sc_method ='StrSSC-Up2+'; gamma0 =0.1; % softS3c works in the range: 0.05 to 0.3
%         opt.sc_method ='StrSSC2+'; gamma0 =0.1; % softS3c works in the range: 0.05 to 0.3
% 
%         opt.sc_method ='softStrSSC-Up2+'; gamma0 =1.0; % softS3c works in the range: 0.2 to 2
%         opt.sc_method ='softStrSSC2+'; gamma0 =1.0; % softS3c works in the range: 0.2 to 2
        opt.sc_method ='softStrSSC-Fix2+'; gamma0 =1.0; % softS3c works in the range: 0.2 to 2

        opt.affine =0;
        opt.outliers =1;
        opt.T =1;% T=1 for spectral clustering and T>2 for spectral assumble clustering
        opt.iter_max =10;
        opt.nu =1;
        opt.gamma0 =gamma0;% This is for reweighting the off-diagonal entries in Z
        opt.lambda =alpha;
        opt.r =0;

        opt.mu_max = 1e8;
        opt.tol =1e-5;
        opt.rho=1.1;
        opt.maxIter =150;

        opt.error_norm ='L1'; % 'L1'
        opt.SSCrho=1; 
        opt.DEBUG =0;

        [missrate2] = StrSSCplus(X, s{n}', opt);

        missrateTot2{n}(j) = 1 - missrate2;
        disp(['* * * ', opt.sc_method, ' missrate 2: ', num2str(1-missrate2)]);    
        disp(['------------------------']);             

        t2 =toc;
        disp(['Esclapsed time:  ', num2str( t2 *                       j )]);
        disp(['Reminding time: ', num2str( t2 * (size(idx,1) - j )),'(s) ,  about  ', num2str( t2 * (size(idx,1) - j )/3600), ' hours.']);  
        results_fn =[opt.sc_method, filename];
        save(results_fn, 'missrateTot1', 'missrateTot2',  'alpha', 'gamma0','opt'); % , 'eval_iterTot2'
    end
    avgmissrate1(n) = mean(missrateTot1{n});
    medmissrate1(n) = median(missrateTot1{n});
    avgmissrate2(n) = mean(missrateTot2{n});
    medmissrate2(n) = median(missrateTot2{n});
    save(results_fn, 'missrateTot1', 'avgmissrate1', 'medmissrate1', 'missrateTot2', 'avgmissrate2', 'medmissrate2', 'nSet', 'alpha', 'gamma0','opt','eval_iterTot2');
end