% run_S3C_CancerGeneData.m
% Description: This code performs subspace clustering for cancer subtype clustering based on gene expression data. This is a
% subspace clustering problem. 
% 
%  [err, result_fn] =run_S3C_CancerGeneData(data_name, parameters) 
%  Inputs: 
%           data_name: the name data set
%           parameters: the used tunable parameters
%
%  Outputs:
%          err  :  error rate
%          result_fn  : file name to same the results
%           
%
% Mar. 20, 2016 by Chun-Guang Li
% Revised by July 15, 2017.
% function [err, result_fn] =run_S3C_CancerGeneData(data_name, parameters)
%addpath('../lrr');
%addpath('../inexact_ladm_mc');
%addpath('../local_comp_represent');
%addpath('../toy_data');
%addpath('../inexact_alm_mc/PROPACK');
%addpath('../inexact_alm_mc');
addpath('../');
addpath('./data');
%addpath('../Evaluation_on_MotionSegmentation/SSC_ADMM_v1.1');
%
nRound =10;
%% Data sets:
data_name ='Novartis_BPLC_zeromean_unitL2'; alpha =5;
data_name ='LungA_local_zeromean_unitL2';  alpha =10;
data_name ='leukemia_zeromean_unitL2'; alpha =4;

str_load =['load ', data_name,'.mat'];
eval(str_load);

str_save_results =[data_name, '_results_', datestr(now,30),'.mat'];

gamma0 =0.02;
nAlg = 5;
ACC =zeros(nRound, nAlg);

for ii =1: nRound
    disp(['iter: ', num2str(ii), '/', num2str(nRound),',  alpha (lambda) = ', num2str(alpha), ', gamma=', num2str(gamma0)]);

    tic
    %% 1. Test  SSC
    r=0; 
    affine = false; 
    %outlier = false; 
    outlier = true; 
    rho=1; 
    [missrate,C1] = SSC(X,r,affine,alpha,outlier,rho,index);
    ACC(ii, 1) =missrate;
    disp(['------------------------']);
    disp(['* * * 1. SSC missrate : ', num2str(missrate)]);
    disp(' ')
    toc

    %% 2. LRR
    opt.lambda =0.15;
    opt.sc_method ='lrr';
    tic;
    opt.affine =0;
    opt.outliers =1;
    opt.T =1;% T=1 for spectral clustering and T>2 for spectral assumble clustering
    opt.r =0;

    opt.mu_max = 1e8;
    opt.tol =1e-5;
    opt.rho=1.1;
    opt.maxIter =150;

    opt.error_norm ='L1'; % 'L1'
    opt.SSCrho=1; %rho = 0.7;
    opt.DEBUG =0;

    [missrate, ~, ~] = StrSSCplus(X, index, opt); 
    disp(['------------------------']);  
    disp(['* * *2.  LRR missrate  : ', num2str(1-missrate)]);    
    disp(' ')
    ACC(ii, 2) =1-missrate;
    toc

    %% 3. StrSSC
%     opt.sc_method ='StrSSC-Up2';
%     opt.sc_method ='StrSSC-Fix2';
%     opt.sc_method ='StrSSC2';
%     opt.sc_method ='StrSSC-Up2+';
%     opt.sc_method ='StrSSC-Fix2+';
%     opt.sc_method ='StrSSC2+';
%     opt.sc_method ='softStrSSC-Up2';
%     opt.sc_method ='softStrSSC-Fix2';
%     opt.sc_method ='softStrSSC2';        
%     opt.sc_method ='softStrSSC-Up2+';
%     opt.sc_method ='softStrSSC-Fix2+';
    opt.sc_method ='softStrSSC2+';
    opt.affine =0;
    opt.outliers =1;
    opt.T =1;% T=1 for spectral clustering and T>2 for spectral assumble clustering
    opt.iter_max =10;
    opt.nu =1;
    opt.r =0;

    opt.gamma0 =gamma0;% This is for reweighting the off-diagonal entries in Z
    opt.lambda =alpha;

    opt.mu_max = 1e8;
    opt.tol =1e-5;
    opt.rho=1.1;
    opt.maxIter =150;

    opt.error_norm ='L1'; % 'L1'
    opt.SSCrho=1; %rho = 0.7;
    opt.DEBUG =0;

    tic
    [missrate] = StrSSCplus(X, index, opt);  
    disp(['------------------------']);           
    disp(['* * * 3.',  opt.sc_method, ' missrate  : ', num2str(1 - missrate)]); 
    disp(' ')   
    ACC(ii, 3) =1 - missrate;
    toc
    save(str_save_results, 'ACC', 'gamma0', 'alpha','nRound');
end
%save(str_save_results, 'ACC', 'gamma_arr', 'alpha','nRound');