% run_CS3C_CancerGeneDataSet.m
% Description: This code is to perform Constraint Structured Sparse Subspace Clustering (CS3C) for cancer subtype clustering
% based on gene expression data.
%
% Example: 
%   m_opt.method1='hardCStrSSC-Fix2';m_opt.method2='hardCStrSSC-Up2';m_opt.method3='hardCStrSSC2';
%   m_opt.method4='softCStrSSC-Fix2';m_opt.method5='softCStrSSC-Up2';m_opt.method6='softCStrSSC2';
%   dataset ='Novartis';p_arr =0.15;gamma0 =0.10;
%   run_CS3C_CancerGeneDataSet(m_opt, dataset, p_arr, gamma0);
%
%
% Mar. 20, 2016 
% by Chun-Guang Li
% Revised by July 15, 2017.
function [ACC, RIE] =run_CS3C_CancerGeneDataSet(m_opt, dataset, p_arr, gamma0, lambda0, iiTOjj, SAVE)
addpath('../lrr');
addpath('../inexact_ladm_mc');
addpath('../local_comp_represent');
addpath('../toy_data');
addpath('../inexact_alm_mc/PROPACK');
addpath('../inexact_alm_mc');
addpath('../');
addpath('./data');
addpath('../Evaluation_on_MotionSegmentation/SSC_ADMM_v1.1');
if (nargin <7)
    SAVE =1;
end
if (nargin <6)
    iiTOjj =[];
end
if (nargin <5)
    switch dataset
        case {'leukemia'}
            lambda0 =4; %alpha =4;
        case {'Novartis'}
            lambda0 =5; %alpha =5;
        case {'LungA'}
            lambda0 =10; % alpha =10;
        otherwise
            lambda0=5;
    end
end
if (nargin <4)
    gamma0 =0.1;
end

%% Data sets:
%data_name ='LungA_local_zeromean_unitL2';  alpha =10;
%data_name ='leukemia_zeromean_unitL2'; alpha =4;
%data_name ='Novartis_BPLC_zeromean_unitL2'; alpha =5;
switch dataset
    case {'Novartis'}
        data_name ='Novartis_BPLC_zeromean_unitL2'; %alpha =5;
    case {'leukemia'}
        data_name ='leukemia_zeromean_unitL2'; %alpha =4;
    case {'LungA'}
        data_name ='LungA_local_zeromean_unitL2'; % alpha =10;
end

str_load =['load ', data_name,'.mat'];
eval(str_load);

%% Generate the side information: Psi
% p_arr = 0.05; % percentage of side-information, e.g., 5%, 10%, 15%
% p_arr = 0.15; % percentage of side-information, e.g., 5%, 10%, 15%
% p_arr = 0.10; % percentage of side-information, e.g., 5%, 10%, 15%

nRound =20; % trials of experiments.
str_psi_results =[data_name, '_SideInfo_Psi_p',num2str(p_arr*100),'_nRound',num2str(nRound),'.mat'];

newPsi =0; % 0: load the existing data set; 1: generate a new data set.
if (newPsi)
    Psi_set =generate_side_info(X, p_arr, index, nRound);
    save(str_psi_results, 'Psi_set', 'p_arr', 'nRound', 'index');
else
    load(str_psi_results, 'Psi_set', 'p_arr', 'nRound', 'index');
end

str_save_results =[data_name, '_CS3C_p',num2str(p_arr(end)*100),'_tune_gamma_results',datestr(now,30),'.mat'];

% alpha_arr =[2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 20,30,50,100, 200];
% gamma_arr =[1e-4, 1e-3, 1e-2, 1e-1, 2e-1, 0.50, 1, 2, 5, 10, 15, 20];
%gamma0 =0.1;
% gamma0 =0.02;
% gamma0 =0.5;
% gamma0 =0.1;
nAlg = 6;
ACC =zeros(nRound, nAlg);
RIE =zeros(nRound, nAlg);
% Eval_ITER =cell(nRound, nAlg);

tic
if isempty(iiTOjj)
    iiTOjj =1: nRound;
end

for jj =iiTOjj            
    
    disp(['jj = ', num2str(jj), '/', num2str( nRound ),',  lambda0 = ', num2str(lambda0), ', gamma0=', num2str(gamma0)]);

    
     %% 0. SSC
     %% 1. Test  SSC
    %r=0;
    %affine = false; 
    %outlier = false; 
    %outlier = true; 
    %rho=1; % 0.7;
    %[missrate,C1] = SSC(X,r,affine,lambda0,outlier,rho,index);
    %missrate =0;
    %ACC(jj, 3) =missrate;
    %disp(['* * * SSC missrate : ', num2str(missrate)]);    
    disp(['------------------------']);
    toc

    
    opt.affine =0;
    opt.outliers =1;
    opt.r =0;
    opt.SSCrho=1;
    
    opt.nu =1;    
    opt.T =1;% T=1 for spectral clustering and T>2 for spectral assumble clustering
    opt.iter_max =10;    
    opt.gamma0 =gamma0;% This is for reweighting the off-diagonal entries in Z
    opt.lambda =lambda0;

    opt.mu_max = 1e8;
    opt.tol =1e-5;
    opt.rho=1.1;
    opt.maxIter =150;

    opt.error_norm ='L1'; % 'L1'
    opt.DEBUG =0;
    opt.Psi =Psi_set(:, :, jj,1);

    
    %gamma0 =0.1;
    %gamma0 =0.02;
    %% 1.  Constraint S3C (hard)
    
    if isfield(m_opt,'method1')
        opt.sc_method =m_opt.method1;
        [missrate,~,~,~, CONS] = ConstraintStrSSC(X, index, opt);       
        %missrate =0;
        disp([' ']);          
        disp(['p=', num2str(p_arr(end)*100), '%, * * * ', opt.sc_method, ' missrate  : ', num2str(1-missrate)]);    
        disp(['------------------------']);
        ACC(jj, 1) =1-missrate;    
        RIE(jj, 1) =CONS;
        toc        
    end

    if isfield(m_opt,'method2')
        opt.sc_method =m_opt.method2;

        [missrate,~,~,~, CONS] = ConstraintStrSSC(X, index, opt);       
        %missrate =0;
        disp([' ']);          
        disp(['p=', num2str(p_arr(end)*100), '%, * * * ', opt.sc_method, ' missrate  : ', num2str(1-missrate)]);    
        disp(['------------------------']);
        ACC(jj, 2) =1-missrate;    
        RIE(jj, 2) =CONS;
        toc
    end
    
    if isfield(m_opt,'method3')
        opt.sc_method =m_opt.method3;

        [missrate,~,~,~, CONS] = ConstraintStrSSC(X, index, opt);       
        %missrate =0;
        disp([' ']);          
        disp(['p=', num2str(p_arr(end)*100), '%, * * * ', opt.sc_method, ' missrate  : ', num2str(1-missrate)]);    
        disp(['------------------------']);
        ACC(jj, 3) =1-missrate;    
        RIE(jj, 3) =CONS;
        toc
    end
    
    %gamma0 =0.02;
    %% 2.  Constraint S3C (soft)

    if isfield(m_opt,'method4')
        opt.sc_method =m_opt.method4;
    
        [missrate,~,~,~, CONS] = ConstraintStrSSC(X, index, opt);       
        disp([' ']);
        disp(['p=', num2str(p_arr(end)*100), '%, * * * ', opt.sc_method, ' missrate  : ', num2str(1-missrate)]);    
        disp(['------------------------']);
        ACC(jj, 4) =1-missrate;
        RIE(jj, 4) =CONS;
        toc
    end
    
    
    if isfield(m_opt,'method5')
        opt.sc_method =m_opt.method5;
    
        [missrate,~,~,~, CONS] = ConstraintStrSSC(X, index, opt);       
        disp([' ']);
        disp(['p=', num2str(p_arr(end)*100), '%, * * * ', opt.sc_method, ' missrate  : ', num2str(1-missrate)]);    
        disp(['------------------------']);
        ACC(jj, 5) =1-missrate;
        RIE(jj, 5) =CONS;
        toc
    end
    
    
    if isfield(m_opt,'method6')
        opt.sc_method =m_opt.method6;
    
        [missrate,~,~,~, CONS] = ConstraintStrSSC(X, index, opt);       
        disp([' ']);
        disp(['p=', num2str(p_arr(end)*100), '%, * * * ', opt.sc_method, ' missrate  : ', num2str(1-missrate)]);    
        disp(['------------------------']);
        ACC(jj, 6) =1-missrate;
        RIE(jj, 6) =CONS;
        toc
    end
    if (SAVE ==1)
        save(str_save_results, 'm_opt','ACC', 'gamma0', 'lambda0','nRound', 'p_arr');
    end
end