% run_CS3C_CancerGeneData.m
% Description: This code is to perform Constraint Structured Sparse Subspace Clustering (CS3C) for cancer subtype clustering
% based on gene expression data.
% 
% Note that the parameters (lambda0,gamma0) can be automatically selected with the help of side-information via function "paraRIEValidation.m" 
%
% Mar. 20, 2016 
% by Chun-Guang Li
% Revised by July 15, 2017.
function [] =run_CS3C_CancerGeneData()
%addpath('../lrr');
%addpath('../inexact_ladm_mc');
%addpath('../local_comp_represent');
%addpath('../toy_data');
%addpath('../inexact_alm_mc/PROPACK');
%addpath('../inexact_alm_mc');
addpath('./data');
%addpath('../Evaluation_on_MotionSegmentation/SSC_ADMM_v1.1');

%% Data sets:
data_name ='LungA_local_zeromean_unitL2';  lambda0 =9; % for p_arr=5%: lambda0 =5;
data_name ='Novartis_BPLC_zeromean_unitL2'; lambda0 =3; % lambda0 =5; 
data_name ='leukemia_zeromean_unitL2'; lambda0 =4;
data_name ='LungA_local_zeromean_unitL2';  lambda0 =5; % for p_arr=10%, 15%: lambda0 =5

str_load =['load ', data_name,'.mat'];
eval(str_load);

%% Generate the side information: Psi
p_arr = 0.05; % percentage of side-information, e.g., 5%, 10%, 15%
p_arr = 0.15; % percentage of side-information, e.g., 5%, 10%, 15%
p_arr = 0.10; % percentage of side-information, e.g., 5%, 10%, 15%
nRound =20; % trials of experiments.
str_psi_results =[data_name, '_SideInfo_Psi_p',num2str(p_arr*100),'_nRound',num2str(nRound),'.mat'];

newPsi =0; % 0: load the existing data set; 1: generate a new data set.
if (newPsi)
    Psi_set =generate_side_info(X, p_arr, index, nRound);
    save(str_psi_results, 'Psi_set', 'p_arr', 'nRound', 'index');
else
    load(str_psi_results, 'Psi_set', 'p_arr', 'nRound', 'index');
end

str_save_results =[data_name, '_CS3C_p',num2str(p_arr(end)*100),'_tune_gamma_results',datestr(now,30),'.mat'];

% lambda_arr =[2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 20,30,50,100, 200];
% gamma_arr =[1e-4, 1e-3, 1e-2, 1e-1, 2e-1, 0.50, 1, 2, 5, 10, 15, 20];
%gamma0 =0.1;
gamma0 =0.02;
gamma0 =0.5;
gamma0 =0.1;
nAlg = 3;
ACC =zeros(nRound, nAlg);
% Eval_ITER =cell(nRound, nAlg);

tic

for jj =1: nRound
    
    disp(['jj = ', num2str(jj), '/', num2str( nRound ),',  lambda0 = ', num2str(lambda0), ', gamma0=', num2str(gamma0)]);

    
     %% 0. SSC
     %% 1. Test  SSC
    r=0;
    affine = false; 
    %outlier = false; 
    outlier = true; 
    rho=1; % 0.7;
    %[missrate,C1] = SSC(X,r,affine,lambda0,outlier,rho,index);
    missrate =0;
    ACC(jj, 3) =missrate;
    disp(['* * * SSC missrate : ', num2str(missrate)]);    
    disp(['------------------------']);
    toc

    
    opt.affine =0;
    opt.outliers =1;
    opt.r =0;
    opt.SSCrho=1;
    
    opt.nu =1;    
    opt.T =1;% T=1 for spectral clustering and T>2 for spectral assumble clustering
    opt.iter_max =10;    
    opt.gamma0 =gamma0;% This is for reweighting the off-diagonal entries in Z
    opt.lambda =lambda0;

    opt.mu_max = 1e8;
    opt.tol =1e-5;
    opt.rho=1.1;
    opt.maxIter =150;

    opt.error_norm ='L1'; % 'L1'
    opt.DEBUG =0;
    opt.Psi =Psi_set(:, :, jj,1);

    
    %gamma0 =0.1;
    %gamma0 =0.02;
    %% 1.  Constraint S3C (hard)
    %opt.sc_method ='hardCStrSSC-Up2';
    %opt.sc_method ='hardCStrSSC-Fix2';
    opt.sc_method ='hardCStrSSC2';
    [missrate] = ConstraintStrSSC(X, index, opt);       
    %missrate =0;
    disp([' ']);          
    disp(['p=', num2str(p_arr(end)*100), '%, * * * ', opt.sc_method, ' missrate  : ', num2str(1-missrate)]);    
    disp(['------------------------']);
    ACC(jj, 1) =1-missrate;    
    toc

    %gamma0 =0.02;
    %% 2.  Constraint S3C (soft)
    %opt.sc_method ='softCStrSSC-Up2';
    %opt.sc_method ='softCStrSSC-Fix2';
    opt.sc_method ='softCStrSSC2';
    [missrate] = ConstraintStrSSC(X, index, opt);       
    disp([' ']);
    disp(['p=', num2str(p_arr(end)*100), '%, * * * ', opt.sc_method, ' missrate  : ', num2str(1-missrate)]);    
    disp(['------------------------']);
    ACC(jj, 2) =1-missrate;
    toc
    save(str_save_results, 'opt','ACC', 'gamma0', 'lambda0','nRound', 'p_arr');
end