% paraRIEValidation.m
%  This code is to determine the proper parameter (\lambda and \gamma) via the RIE (Rand Index Estimator)  which is as a
%  function of lambda and gamma. 
%  
%   a) Given a search set for each of lambda and gamma;
%   b) For each case, perform CS3C with a pair of (lambda, gamma) and evaluate the Rand Index Estimator (RIE);
%   c) Find the (lambda, gamma) with the best RIE
%
%      [ii, jj, logicRIEidx, lambda0, gamma0]=paraRIEValidation(RIE, lambda_arr, gamma_arr)
%       Inputs:
%       RIE: RIE(ii, jj) ---the ii-th row and jj-th column---of RIE records the RIE value with respect to the ii-th lambda in
%               lambda_arr and the jj-th gamma in gamma_arr
%
%       Outputs:
%        (ii, jj) : the location of the best RIE value
%        logicRIEidx : a matrix of logical values, which indicate the positions having the best RIE value.
%        (lambda0, gamma0) : the returned best parameters when lambda_arr and gamma_arr are given.
%
%       Use: [ii, jj, logicRIEidx]=paraRIEValidation(RIE)
%
%%    Reference:
%    [1] Chun-Guang Li, Chong You, and Ren Vidal, "Structured Sparse Subspace Clustering: 
%         A Joint Affinity Learning and Subspace Clustering Framework", IEEE Trans. Image 
%         Processing, Vol. 26, No. 6, June 2017, pp.2988-3001.
%    [2] Chun-Guang Li, et al. "Constrained Sparse Subspace Clustering with Side Information, ICPR 2018, pp.2093-2099. 
%        https://arxiv.org/abs/1805.08183
%
% CHUNGUANG LI
% May 12, 2015; Revised July 28 and August 18, 2017.
function [ii, jj, logicRIEidx, lambda0, gamma0]=paraRIEValidation(RIE, lambda_arr, gamma_arr)

% find the best RIE and return the corresponding lambda and gamma

[val1, index1] =max(RIE,[], 1); % find the best RIE in each column, i.e. find the best lambda for each gamma

%[val2, index2] =max(RIE,[], 2);

[val2, index2] =max(val1); % find the best RIE, i.e. find the best lambda and the best gamma

% Find the best RIE from the 'index2(1)'-th column and the 'index1(index2(1))'-th row
jj =index2(1);
ii =index1(index2(1));

% bestRIE =RIE(ii, jj);

% find all the indexes which have the best RIE value
logicRIEidx =(RIE==val2);

if (nargin >=3)
    lambda0 =lambda_arr(ii);
    gamma0 =gamma_arr(jj);
else
    lambda0 =NaN;
    gamma0 =NaN;
end

