% generate_side_info.m
%
%
%
%
% By Chunguang Li
% Apr. 8, 2016
function [Psi] = generate_side_info(X, p_arr, index, nRound)

T = length(p_arr);
Psi = zeros(size(X, 2), size(X, 2), nRound, T);

%% generate the structure matrix
label = unique(index);
k = length(label);
M = form_structure_matrix(index, k);

%% must-links:  -1
%% cannot-links: +1
sideM = 1 - 2*M;

for i=1:T        
    p =p_arr(i);
    for j=1:nRound
        tmp =zeros(size(M));
        inds =(rand(size(M))<=p);
        
        tmp(inds) =sideM(inds);        
        Psi(:, :, j, i) =tmp;
    end
end

function M = form_structure_matrix(idx,n)
if nargin<2
    n =size(idx,2);
end
M =zeros(n);
id =unique(idx);
for i =1:length(id)
    idx_i =find(idx == id(i));
    M(idx_i,idx_i)=ones(size(idx_i,2));
end  