function [error, ssr] = evalSSR_error(C, s)
% C \in R^N-by-N: representation matrix by self-expressiveness based method
% s \in {1, 2, ... n}^N: group labels
%     
% error: average SSR error.

N = length(s);

error = 0;
for iN = 1:N
    if norm(C(:, iN), 1) < eps
        error = error + 1;
    else
        error = error + norm( C(s ~= s(iN), iN), 1 ) / norm(C(:, iN), 1);
    end
end
error = error / N;

ssr =0;
for iN = 1:N
    if norm(C(:, iN), 1) < eps
        ssr = ssr + 0;
    else
        ssr = ssr + norm( C(s == s(iN), iN), 1 ) / norm(C(:, iN), 1);
    end
end
ssr = ssr / N;
end
