% CS3C_para_Selection_via_RIE.m
%
% Description: This code is used to determine the parameter (\lambda, \alpha) in CS3C based on checking RIE(\lambda, \alpha)
% in which RIE is the Rand Index Estimator to evaluate the quality of the clustering result with respect to the given
% side-information.
% 
%  use: 
%  dataset ='Novartis';p_arr=0.10; m_opt.method6='softCStrSSC2';iiTojj=13:13;
%  CS3C_para_Selection_via_RIE(dataset, p_arr, m_opt, iiTojj);
%
%%    Reference:
%    [1] Chun-Guang Li, Chong You, and Ren Vidal, "Structured Sparse Subspace Clustering: 
%         A Joint Affinity Learning and Subspace Clustering Framework", IEEE Trans. Image 
%         Processing, Vol. 26, No. 6, June 2017, pp.2988-3001.
%    [2] Chun-Guang Li, et al. "Constrained Sparse Subspace Clustering with Side Information, ICPR 2018, pp.2093-2099. 
%        https://arxiv.org/abs/1805.08183
%
%
% Date: July 15, 2016; Revised August 17, 2017
% By Chun-Guang Li
function [] = CS3C_para_Selection_via_RIE(dataset, p_arr, m_opt, iiTojj)

% m_opt.method1='hardCStrSSC-Fix2';
% m_opt.method2='hardCStrSSC-Up2';
% m_opt.method3='hardCStrSSC2';
% m_opt.method4='softCStrSSC-Fix2';
% m_opt.method5='softCStrSSC-Up2';

% m_opt.method6='softCStrSSC2';
% dataset ='Novartis';
% p_arr =0.15;

% gamma0 =0.10;
% iiTojj =6:6;
SAVE =0;
lambda_arr =[2 3 4 5 6 7 8 9 10];
gamma_arr =[0.05 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 1.2 1.5 2];
ERR =ones(length(lambda_arr), length(gamma_arr));
RIE =zeros(length(lambda_arr), length(gamma_arr));
for ii =1:length(lambda_arr)
    for jj=1:length(gamma_arr)
        lambda0 =lambda_arr(ii);
        gamma0 =gamma_arr(jj);
        [tmpACC, tmpRIE] = run_CS3C_CancerGeneDataSet(m_opt, dataset, p_arr, gamma0, lambda0, iiTojj, SAVE);
        ERR(ii,jj) =tmpACC(iiTojj, 6);
        RIE(ii,jj) =tmpRIE(iiTojj, 6);
    end
end
str_filename =['CS3C_para_selection_via_RIE_',dataset,'_p', num2str(100*p_arr),'_for_',m_opt.method6,'_', datestr(now,30),'.mat'];
save(str_filename,'ERR', 'RIE', 'm_opt', 'lambda_arr', 'gamma_arr');
% Show results RIE(\lambda0, \gamma0) and ERR(\lambda0, \gamma0):
strColormap ='jet';
h = figure;
subplot(121);
show_paraCrossValidation(lambda_arr, gamma_arr, ERR, 'ERR', h, strColormap);
subplot(122);
show_paraCrossValidation(lambda_arr, gamma_arr, RIE, 'RIE (CONS)', h, strColormap);